/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.internal.OtlpDeclarativeConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterComponentProvider
implements ComponentProvider<SpanExporter> {
    @Override
    public Class<SpanExporter> getType() {
        return SpanExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public SpanExporter create(DeclarativeConfigProperties config) {
        String protocol = OtlpDeclarativeConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }
}

