/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.http.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.traces.SpanReusableDataMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.data.SpanData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final SpanReusableDataMarshaler marshaler;

    OtlpHttpSpanExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.marshaler = new SpanReusableDataMarshaler(memoryMode, delegate::export);
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public OtlpHttpSpanExporterBuilder toBuilder() {
        return new OtlpHttpSpanExporterBuilder(this.builder.copy(), this.marshaler.getMemoryMode());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.marshaler.export(spans);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.marshaler.getMemoryMode()));
        return joiner.toString();
    }
}

