/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.trace.StatusCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.ProtoEnumInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.proto.trace.v1.internal.Status;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.data.StatusData;
import java.io.IOException;

final class SpanStatusMarshaler
extends MarshalerWithSize {
    private final ProtoEnumInfo protoStatusCode;
    private final byte[] descriptionUtf8;

    static SpanStatusMarshaler create(StatusData status) {
        ProtoEnumInfo protoStatusCode = SpanStatusMarshaler.toProtoSpanStatus(status);
        byte[] description = MarshalerUtil.toBytes(status.getDescription());
        return new SpanStatusMarshaler(protoStatusCode, description);
    }

    private SpanStatusMarshaler(ProtoEnumInfo protoStatusCode, byte[] descriptionUtf8) {
        super(SpanStatusMarshaler.computeSize(protoStatusCode, descriptionUtf8));
        this.protoStatusCode = protoStatusCode;
        this.descriptionUtf8 = descriptionUtf8;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeString(Status.MESSAGE, this.descriptionUtf8);
        output.serializeEnum(Status.CODE, this.protoStatusCode);
    }

    private static int computeSize(ProtoEnumInfo protoStatusCode, byte[] descriptionUtf8) {
        int size = 0;
        size += MarshalerUtil.sizeBytes(Status.MESSAGE, descriptionUtf8);
        return size += MarshalerUtil.sizeEnum(Status.CODE, protoStatusCode);
    }

    static ProtoEnumInfo toProtoSpanStatus(StatusData status) {
        ProtoEnumInfo protoStatusCode = Status.StatusCode.STATUS_CODE_UNSET;
        if (status.getStatusCode() == StatusCode.OK) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
        } else if (status.getStatusCode() == StatusCode.ERROR) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_ERROR;
        }
        return protoStatusCode;
    }
}

