/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.InstrumentationScopeMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.ResourceMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.metrics.InstrumentationScopeMetricsMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.metrics.MetricMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.proto.metrics.v1.internal.ResourceMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.resources.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceMetricsMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrl;
    private final InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalers;

    public static ResourceMetricsMarshaler[] create(Collection<MetricData> metricDataList) {
        Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> resourceAndScopeMap = ResourceMetricsMarshaler.groupByResourceAndScope(metricDataList);
        ResourceMetricsMarshaler[] resourceMetricsMarshalers = new ResourceMetricsMarshaler[resourceAndScopeMap.size()];
        int posResource = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> entry : resourceAndScopeMap.entrySet()) {
            InstrumentationScopeMetricsMarshaler[] instrumentationLibrarySpansMarshalers = new InstrumentationScopeMetricsMarshaler[entry.getValue().size()];
            int posInstrumentation = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<Marshaler>> entryIs : entry.getValue().entrySet()) {
                instrumentationLibrarySpansMarshalers[posInstrumentation++] = new InstrumentationScopeMetricsMarshaler(InstrumentationScopeMarshaler.create(entryIs.getKey()), MarshalerUtil.toBytes(entryIs.getKey().getSchemaUrl()), entryIs.getValue());
            }
            resourceMetricsMarshalers[posResource++] = new ResourceMetricsMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationLibrarySpansMarshalers);
        }
        return resourceMetricsMarshalers;
    }

    ResourceMetricsMarshaler(ResourceMarshaler resourceMarshaler, byte[] schemaUrl, InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalers) {
        super(ResourceMetricsMarshaler.calculateSize(resourceMarshaler, schemaUrl, instrumentationScopeMetricsMarshalers));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrl = schemaUrl;
        this.instrumentationScopeMetricsMarshalers = instrumentationScopeMetricsMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ResourceMetrics.RESOURCE, this.resourceMarshaler);
        output.serializeRepeatedMessage(ResourceMetrics.SCOPE_METRICS, this.instrumentationScopeMetricsMarshalers);
        output.serializeString(ResourceMetrics.SCHEMA_URL, this.schemaUrl);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] schemaUrl, InstrumentationScopeMetricsMarshaler[] instrumentationScopeMetricsMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ResourceMetrics.RESOURCE, resourceMarshaler);
        size += MarshalerUtil.sizeBytes(ResourceMetrics.SCHEMA_URL, schemaUrl);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceMetrics.SCOPE_METRICS, (Marshaler[])instrumentationScopeMetricsMarshalers);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> groupByResourceAndScope(Collection<MetricData> metricDataList) {
        return MarshalerUtil.groupByResourceAndScope(metricDataList, MetricData::getResource, MetricData::getInstrumentationScopeInfo, MetricMarshaler::create);
    }
}

