/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.internal.shaded.WeakConcurrentMap;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.KeyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.proto.common.v1.internal.InstrumentationScope;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.InstrumentationScopeInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class InstrumentationScopeMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<InstrumentationScopeInfo, InstrumentationScopeMarshaler> SCOPE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction<InstrumentationScopeInfo, InstrumentationScopeMarshaler>();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static InstrumentationScopeMarshaler create(InstrumentationScopeInfo scopeInfo) {
        InstrumentationScopeMarshaler cached = (InstrumentationScopeMarshaler)SCOPE_MARSHALER_CACHE.get((Object)scopeInfo);
        if (cached == null) {
            byte[] name = MarshalerUtil.toBytes(scopeInfo.getName());
            byte[] version = MarshalerUtil.toBytes(scopeInfo.getVersion());
            KeyValueMarshaler[] attributes = KeyValueMarshaler.createForAttributes(scopeInfo.getAttributes());
            RealInstrumentationScopeMarshaler realMarshaler = new RealInstrumentationScopeMarshaler(name, version, attributes);
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields(realMarshaler);
            cached = new InstrumentationScopeMarshaler(binaryBos.toByteArray(), json);
            SCOPE_MARSHALER_CACHE.put((Object)scopeInfo, (Object)cached);
        }
        return cached;
    }

    private InstrumentationScopeMarshaler(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealInstrumentationScopeMarshaler
    extends MarshalerWithSize {
        private final byte[] name;
        private final byte[] version;
        private final KeyValueMarshaler[] attributes;

        RealInstrumentationScopeMarshaler(byte[] name, byte[] version, KeyValueMarshaler[] attributes) {
            super(RealInstrumentationScopeMarshaler.computeSize(name, version, attributes));
            this.name = name;
            this.version = version;
            this.attributes = attributes;
        }

        @Override
        protected void writeTo(Serializer output) throws IOException {
            output.serializeString(InstrumentationScope.NAME, this.name);
            output.serializeString(InstrumentationScope.VERSION, this.version);
            output.serializeRepeatedMessage(InstrumentationScope.ATTRIBUTES, this.attributes);
        }

        private static int computeSize(byte[] name, byte[] version, KeyValueMarshaler[] attributes) {
            return MarshalerUtil.sizeBytes(InstrumentationScope.NAME, name) + MarshalerUtil.sizeBytes(InstrumentationScope.VERSION, version) + MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)InstrumentationScope.ATTRIBUTES, (Marshaler[])attributes);
        }
    }
}

