/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.otelagent;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceAttributesFromOtelAgent {
    private static final String[] OTEL_JARS = new String[]{"opentelemetry-api-1.29.0.jar", "opentelemetry-context-1.29.0.jar"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getResourceAttributes(String instrumentationScopeName) {
        try {
            Path tmpDir = Files.createTempDirectory(instrumentationScopeName + "-", new FileAttribute[0]);
            try {
                URL[] otelJars = ResourceAttributesFromOtelAgent.copyOtelJarsToTempDir(tmpDir, instrumentationScopeName);
                try (URLClassLoader classLoader = new URLClassLoader(otelJars);){
                    Class<?> globalOpenTelemetryClass = classLoader.loadClass("io.opentelemetry.api.GlobalOpenTelemetry");
                    Object globalOpenTelemetry = globalOpenTelemetryClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                    if (!globalOpenTelemetry.getClass().getSimpleName().contains("ApplicationOpenTelemetry")) return Collections.emptyMap();
                    Object applicationMeterProvider = ResourceAttributesFromOtelAgent.callMethod("getMeterProvider", globalOpenTelemetry);
                    Object agentMeterProvider = ResourceAttributesFromOtelAgent.getField("agentMeterProvider", applicationMeterProvider);
                    Object sdkMeterProvider = ResourceAttributesFromOtelAgent.getField("delegate", agentMeterProvider);
                    Object sharedState = ResourceAttributesFromOtelAgent.getField("sharedState", sdkMeterProvider);
                    Object resource = ResourceAttributesFromOtelAgent.callMethod("getResource", sharedState);
                    Object attributes = ResourceAttributesFromOtelAgent.callMethod("getAttributes", resource);
                    Map attributeMap = (Map)ResourceAttributesFromOtelAgent.callMethod("asMap", attributes);
                    HashMap<String, String> result = new HashMap<String, String>();
                    for (Map.Entry entry : attributeMap.entrySet()) {
                        if (entry.getKey() == null || entry.getValue() == null) continue;
                        result.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    Map map = Collections.unmodifiableMap(result);
                    return map;
                }
            }
            finally {
                ResourceAttributesFromOtelAgent.deleteTempDir(tmpDir.toFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyMap();
    }

    private static Object getField(String name, Object obj) throws Exception {
        Field field = obj.getClass().getDeclaredField(name);
        field.setAccessible(true);
        return field.get(obj);
    }

    private static Object callMethod(String name, Object obj) throws Exception {
        Method method = obj.getClass().getMethod(name, new Class[0]);
        method.setAccessible(true);
        return method.invoke(obj, new Object[0]);
    }

    private static URL[] copyOtelJarsToTempDir(Path tmpDir, String instrumentationScopeName) throws Exception {
        URL[] result = new URL[OTEL_JARS.length];
        for (int i = 0; i < OTEL_JARS.length; ++i) {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("lib/" + OTEL_JARS[i]);
            if (inputStream == null) {
                throw new IllegalStateException("Error initializing " + instrumentationScopeName + ": lib/" + OTEL_JARS[i] + " not found in classpath.");
            }
            File outputFile = tmpDir.resolve(OTEL_JARS[i]).toFile();
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            inputStream.close();
            result[i] = outputFile.toURI().toURL();
        }
        return result;
    }

    private static void deleteTempDir(File tmpDir) {
        for (File file : tmpDir.listFiles()) {
            file.delete();
        }
        tmpDir.delete();
    }
}

