/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.resources.Resource;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusCounter;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusInfo;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusStateSet;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.Unit;
import javax.annotation.Nullable;

class PrometheusMetricData<T extends PrometheusData<?>>
implements MetricData {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String unit;
    T data;

    PrometheusMetricData(MetricMetadata metricMetadata, T data, InstrumentationScopeInfo instrumentationScopeInfo, Resource resource) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.resource = resource;
        this.name = this.getNameWithoutUnit(metricMetadata);
        this.description = metricMetadata.getHelp();
        this.unit = PrometheusMetricData.convertUnit(metricMetadata.getUnit());
        this.data = data;
    }

    private String getNameWithoutUnit(MetricMetadata metricMetadata) {
        String name = metricMetadata.getName();
        if (metricMetadata.getUnit() != null) {
            String unit = metricMetadata.getUnit().toString();
            if (name.endsWith(unit)) {
                name = name.substring(0, name.length() - unit.length());
            }
            while (name.endsWith("_")) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    @Nullable
    static String convertUnit(@Nullable Unit unit) {
        if (unit == null) {
            return null;
        }
        switch (unit.toString()) {
            case "days": {
                return "d";
            }
            case "hours": {
                return "h";
            }
            case "minutes": {
                return "min";
            }
            case "seconds": {
                return "s";
            }
            case "milliseconds": {
                return "ms";
            }
            case "microseconds": {
                return "us";
            }
            case "nanoseconds": {
                return "ns";
            }
            case "bytes": {
                return "By";
            }
            case "kibibytes": {
                return "KiBy";
            }
            case "mebibytes": {
                return "MiBy";
            }
            case "gibibytes": {
                return "GiBy";
            }
            case "tibibytes": {
                return "TiBy";
            }
            case "kilobytes": {
                return "KBy";
            }
            case "megabytes": {
                return "MBy";
            }
            case "gigabytes": {
                return "GBy";
            }
            case "terabytes": {
                return "TBy";
            }
            case "meters": {
                return "m";
            }
            case "volts": {
                return "V";
            }
            case "amperes": {
                return "A";
            }
            case "joules": {
                return "J";
            }
            case "watts": {
                return "W";
            }
            case "grams": {
                return "g";
            }
            case "celsius": {
                return "Cel";
            }
            case "hertz": {
                return "Hz";
            }
            case "percent": {
                return "%";
            }
        }
        return unit.toString();
    }

    public Resource getResource() {
        return this.resource;
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getUnit() {
        return this.unit;
    }

    public MetricDataType getType() {
        return ((PrometheusData)this.data).getType();
    }

    public T getData() {
        return this.data;
    }

    public SumData<DoublePointData> getDoubleSumData() {
        if (this.data instanceof PrometheusCounter) {
            return (PrometheusCounter)this.data;
        }
        if (this.data instanceof PrometheusStateSet) {
            return (PrometheusStateSet)this.data;
        }
        if (this.data instanceof PrometheusInfo) {
            return (PrometheusInfo)this.data;
        }
        return super.getDoubleSumData();
    }
}

