/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.ExponentialHistogramBucketsImpl;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.ExponentialHistogramPointDataImpl;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.NativeHistogramBuckets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class PrometheusNativeHistogram
extends PrometheusData<ExponentialHistogramPointData>
implements ExponentialHistogramData {
    private final List<ExponentialHistogramPointData> points;

    PrometheusNativeHistogram(HistogramSnapshot snapshot, long currentTimeMillis) {
        super(MetricDataType.EXPONENTIAL_HISTOGRAM);
        this.points = snapshot.getDataPoints().stream().map(dataPoint -> this.toOtelDataPoint((HistogramSnapshot.HistogramDataPointSnapshot)dataPoint, currentTimeMillis)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public AggregationTemporality getAggregationTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    public Collection<ExponentialHistogramPointData> getPoints() {
        return this.points;
    }

    private ExponentialHistogramPointData toOtelDataPoint(HistogramSnapshot.HistogramDataPointSnapshot dataPoint, long currentTimeMillis) {
        if (!dataPoint.hasNativeHistogramData()) {
            return null;
        }
        return new ExponentialHistogramPointDataImpl(dataPoint.getNativeSchema(), dataPoint.hasSum() ? dataPoint.getSum() : Double.NaN, dataPoint.hasCount() ? dataPoint.getCount() : this.calculateCount(dataPoint), dataPoint.getNativeZeroCount(), Double.NaN, Double.NaN, this.convertBuckets(dataPoint.getNativeSchema(), dataPoint.getNativeBucketsForPositiveValues()), this.convertBuckets(dataPoint.getNativeSchema(), dataPoint.getNativeBucketsForNegativeValues()), this.getStartEpochNanos((DataPointSnapshot)dataPoint), this.getEpochNanos((DataPointSnapshot)dataPoint, currentTimeMillis), this.labelsToAttributes(dataPoint.getLabels()), this.convertExemplars(dataPoint.getExemplars()));
    }

    private ExponentialHistogramBuckets convertBuckets(int scale, NativeHistogramBuckets buckets) {
        if (buckets.size() == 0) {
            return new ExponentialHistogramBucketsImpl(scale, 0);
        }
        int offset = buckets.getBucketIndex(0);
        ExponentialHistogramBucketsImpl result = new ExponentialHistogramBucketsImpl(scale, offset - 1);
        int currentBucket = 0;
        for (int i = offset; i <= buckets.getBucketIndex(buckets.size() - 1); ++i) {
            if (buckets.getBucketIndex(currentBucket) == i) {
                result.addCount(buckets.getCount(currentBucket));
                ++currentBucket;
                continue;
            }
            result.addCount(0L);
        }
        return result;
    }

    private long calculateCount(HistogramSnapshot.HistogramDataPointSnapshot dataPoint) {
        int i;
        long result = 0L;
        for (i = 0; i < dataPoint.getNativeBucketsForPositiveValues().size(); ++i) {
            result += dataPoint.getNativeBucketsForPositiveValues().getCount(i);
        }
        for (i = 0; i < dataPoint.getNativeBucketsForNegativeValues().size(); ++i) {
            result += dataPoint.getNativeBucketsForNegativeValues().getCount(i);
        }
        return result += dataPoint.getNativeZeroCount();
    }
}

