/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.ResourceConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.prometheus.metrics.config.ExporterOpenTelemetryProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.exporter.opentelemetry.OpenTelemetryExporter;
import io.prometheus.metrics.exporter.opentelemetry.PrometheusInstrumentationScope;
import io.prometheus.metrics.exporter.opentelemetry.PrometheusMetricProducer;
import io.prometheus.metrics.exporter.opentelemetry.PropertiesResourceProvider;
import io.prometheus.metrics.exporter.opentelemetry.PropertyMapper;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.otelagent.ResourceAttributesFromOtelAgent;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class OtelAutoConfig {
    private static final String SERVICE_INSTANCE_ID = "service.instance.id";

    static MetricReader createReader(OpenTelemetryExporter.Builder builder, PrometheusProperties config, PrometheusRegistry registry) {
        AtomicReference<MetricReader> readerRef = new AtomicReference<MetricReader>();
        InstrumentationScopeInfo instrumentationScopeInfo = PrometheusInstrumentationScope.loadInstrumentationScopeInfo();
        AutoConfiguredOpenTelemetrySdk sdk = OtelAutoConfig.createAutoConfiguredOpenTelemetrySdk(builder, readerRef, config.getExporterOpenTelemetryProperties(), instrumentationScopeInfo);
        MetricReader reader = readerRef.get();
        reader.register((CollectionRegistration)new PrometheusMetricProducer(registry, instrumentationScopeInfo, OtelAutoConfig.getResourceField(sdk)));
        return reader;
    }

    static AutoConfiguredOpenTelemetrySdk createAutoConfiguredOpenTelemetrySdk(OpenTelemetryExporter.Builder builder, AtomicReference<MetricReader> readerRef, ExporterOpenTelemetryProperties properties, InstrumentationScopeInfo instrumentationScopeInfo) {
        PropertyMapper propertyMapper = PropertyMapper.create(properties, builder);
        return AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> propertyMapper.configLowPriority).addPropertiesCustomizer(c -> PropertyMapper.customizeProperties(propertyMapper.configHighPriority, c)).addMetricReaderCustomizer((reader, unused) -> {
            readerRef.set((MetricReader)reader);
            return reader;
        }).addResourceCustomizer((resource, c) -> OtelAutoConfig.getResource(builder, resource, instrumentationScopeInfo, c, properties)).build();
    }

    private static Resource getResource(OpenTelemetryExporter.Builder builder, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, ConfigProperties configProperties, ExporterOpenTelemetryProperties properties) {
        return resource.merge(PropertiesResourceProvider.mergeResource(builder.resourceAttributes, builder.serviceName, builder.serviceNamespace, builder.serviceInstanceId, builder.serviceVersion)).merge(ResourceConfiguration.createEnvironmentResource((ConfigProperties)configProperties)).merge(PropertiesResourceProvider.mergeResource(properties.getResourceAttributes(), properties.getServiceName(), properties.getServiceNamespace(), properties.getServiceInstanceId(), properties.getServiceVersion())).merge(Resource.create((Attributes)OtelAutoConfig.otelResourceAttributes(instrumentationScopeInfo)));
    }

    private static Attributes otelResourceAttributes(InstrumentationScopeInfo instrumentationScopeInfo) {
        AttributesBuilder builder = Attributes.builder();
        Map attributes = ResourceAttributesFromOtelAgent.getResourceAttributes((String)instrumentationScopeInfo.getName());
        String id = (String)attributes.get(SERVICE_INSTANCE_ID);
        if (id != null) {
            builder.put(SERVICE_INSTANCE_ID, id);
        }
        return builder.build();
    }

    static Resource getResourceField(AutoConfiguredOpenTelemetrySdk sdk) {
        try {
            Method method = AutoConfiguredOpenTelemetrySdk.class.getDeclaredMethod("getResource", new Class[0]);
            method.setAccessible(true);
            return (Resource)method.invoke((Object)sdk, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

