/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.JmxMBeanPropertyCache;
import io.prometheus.jmx.JmxScraper;
import io.prometheus.jmx.MatchedRule;
import io.prometheus.jmx.MatchedRulesCache;
import io.prometheus.jmx.ObjectNameAttributeFilter;
import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFactory;
import io.prometheus.jmx.shaded.org.yaml.snakeyaml.Yaml;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.Unit;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxCollector
implements MultiCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxCollector.class);
    private final Mode mode;
    private PrometheusRegistry prometheusRegistry;
    private Config config;
    private File configFile;
    private long createTimeNanoSecs = System.nanoTime();
    private Counter configReloadSuccess;
    private Counter configReloadFailure;
    private Gauge jmxScrapeDurationSeconds;
    private Gauge jmxScrapeError;
    private Gauge jmxScrapeCachedBeans;
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache = new JmxMBeanPropertyCache();

    public JmxCollector(File in) throws IOException, MalformedObjectNameException {
        this(in, null);
    }

    public JmxCollector(File in, Mode mode) throws IOException, MalformedObjectNameException {
        this.configFile = in;
        this.mode = mode;
        this.config = this.loadConfig((Map)new Yaml().load(new FileReader(in)));
        this.config.lastUpdate = this.configFile.lastModified();
        this.exitOnConfigError();
    }

    public JmxCollector(String yamlConfig) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(yamlConfig));
        this.mode = null;
    }

    public JmxCollector(InputStream inputStream) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(inputStream));
        this.mode = null;
    }

    public JmxCollector register() {
        return this.register(PrometheusRegistry.defaultRegistry);
    }

    public JmxCollector register(PrometheusRegistry prometheusRegistry) {
        this.prometheusRegistry = prometheusRegistry;
        this.configReloadSuccess = (Counter)((Counter.Builder)Counter.builder().name("jmx_config_reload_success_total").help("Number of times configuration have successfully been reloaded.")).register(prometheusRegistry);
        this.configReloadFailure = (Counter)((Counter.Builder)Counter.builder().name("jmx_config_reload_failure_total").help("Number of times configuration have failed to be reloaded.")).register(prometheusRegistry);
        this.jmxScrapeDurationSeconds = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("jmx_scrape_duration_seconds")).help("Time this JMX scrape took, in seconds.")).unit(Unit.SECONDS)).register(prometheusRegistry);
        this.jmxScrapeError = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("jmx_scrape_error")).help("Non-zero if this scrape failed.")).register(prometheusRegistry);
        this.jmxScrapeCachedBeans = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("jmx_scrape_cached_beans")).help("Number of beans with their matching rule cached")).register(prometheusRegistry);
        prometheusRegistry.register(this);
        return this;
    }

    private void exitOnConfigError() {
        if (this.mode == Mode.AGENT && !this.config.jmxUrl.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Configuration error: When running jmx_exporter as a Java agent, you must not configure 'jmxUrl' or 'hostPort' because you don't want to monitor a remote JVM.", new Object[0]);
            System.exit(-1);
        }
        if (this.mode == Mode.STANDALONE && this.config.jmxUrl.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Configuration error: When running jmx_exporter in standalone mode (using jmx_prometheus_httpserver-*.jar) you must configure 'jmxUrl' or 'hostPort'.", new Object[0]);
            System.exit(-1);
        }
    }

    private void reloadConfig() {
        try (FileReader fr = new FileReader(this.configFile);){
            Map newYamlConfig = (Map)new Yaml().load(fr);
            this.config = this.loadConfig(newYamlConfig);
            this.config.lastUpdate = this.configFile.lastModified();
            this.configReloadSuccess.inc();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Configuration reload failed: %s", e);
            this.configReloadFailure.inc();
        }
    }

    private synchronized Config getLatestConfig() {
        long mtime;
        if (this.configFile != null && (mtime = this.configFile.lastModified()) > this.config.lastUpdate) {
            LOGGER.log(Level.FINE, "Configuration file changed, reloading...", new Object[0]);
            this.reloadConfig();
        }
        this.exitOnConfigError();
        return this.config;
    }

    private Config loadConfig(Map<String, Object> yamlConfig) throws MalformedObjectNameException {
        List names;
        Config cfg = new Config();
        if (yamlConfig == null) {
            yamlConfig = new HashMap<String, Object>();
        }
        if (yamlConfig.containsKey("startDelaySeconds")) {
            try {
                cfg.startDelaySeconds = (Integer)yamlConfig.get("startDelaySeconds");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number provided for startDelaySeconds", e);
            }
        }
        if (yamlConfig.containsKey("hostPort")) {
            if (yamlConfig.containsKey("jmxUrl")) {
                throw new IllegalArgumentException("At most one of hostPort and jmxUrl must be provided");
            }
            cfg.jmxUrl = "service:jmx:rmi:///jndi/rmi://" + yamlConfig.get("hostPort") + "/jmxrmi";
        } else if (yamlConfig.containsKey("jmxUrl")) {
            cfg.jmxUrl = (String)yamlConfig.get("jmxUrl");
        }
        if (yamlConfig.containsKey("username")) {
            cfg.username = (String)yamlConfig.get("username");
        }
        if (yamlConfig.containsKey("password")) {
            cfg.password = (String)yamlConfig.get("password");
        }
        if (yamlConfig.containsKey("ssl")) {
            cfg.ssl = (Boolean)yamlConfig.get("ssl");
        }
        if (yamlConfig.containsKey("lowercaseOutputName")) {
            cfg.lowercaseOutputName = (Boolean)yamlConfig.get("lowercaseOutputName");
        }
        if (yamlConfig.containsKey("lowercaseOutputLabelNames")) {
            cfg.lowercaseOutputLabelNames = (Boolean)yamlConfig.get("lowercaseOutputLabelNames");
        }
        if (yamlConfig.containsKey("includeObjectNames")) {
            names = (List)yamlConfig.get("includeObjectNames");
            for (Object name : names) {
                cfg.includeObjectNames.add(new ObjectName((String)name));
            }
        } else if (yamlConfig.containsKey("whitelistObjectNames")) {
            names = (List)yamlConfig.get("whitelistObjectNames");
            for (Object name : names) {
                cfg.includeObjectNames.add(new ObjectName((String)name));
            }
        } else {
            cfg.includeObjectNames.add(null);
        }
        if (yamlConfig.containsKey("excludeObjectNames")) {
            names = (List)yamlConfig.get("excludeObjectNames");
            for (Object name : names) {
                cfg.excludeObjectNames.add(new ObjectName((String)name));
            }
        } else if (yamlConfig.containsKey("blacklistObjectNames")) {
            names = (List)yamlConfig.get("blacklistObjectNames");
            for (Object name : names) {
                cfg.excludeObjectNames.add(new ObjectName((String)name));
            }
        }
        if (yamlConfig.containsKey("rules")) {
            List configRules = (List)yamlConfig.get("rules");
            Iterator iterator = configRules.iterator();
            while (iterator.hasNext()) {
                Map ruleObject;
                Map yamlRule = ruleObject = (Map)iterator.next();
                Rule rule = new Rule();
                cfg.rules.add(rule);
                if (yamlRule.containsKey("pattern")) {
                    rule.pattern = Pattern.compile("^.*(?:" + yamlRule.get("pattern") + ").*$");
                }
                if (yamlRule.containsKey("name")) {
                    rule.name = (String)yamlRule.get("name");
                }
                if (yamlRule.containsKey("value")) {
                    rule.value = String.valueOf(yamlRule.get("value"));
                }
                if (yamlRule.containsKey("valueFactor")) {
                    String valueFactor = String.valueOf(yamlRule.get("valueFactor"));
                    try {
                        rule.valueFactor = Double.valueOf(valueFactor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (yamlRule.containsKey("attrNameSnakeCase")) {
                    rule.attrNameSnakeCase = (Boolean)yamlRule.get("attrNameSnakeCase");
                }
                if (yamlRule.containsKey("cache")) {
                    rule.cache = (Boolean)yamlRule.get("cache");
                }
                if (yamlRule.containsKey("type")) {
                    String t = (String)yamlRule.get("type");
                    if ("UNTYPED".equals(t)) {
                        t = "UNKNOWN";
                    }
                    rule.type = t;
                }
                if (yamlRule.containsKey("help")) {
                    rule.help = (String)yamlRule.get("help");
                }
                if (yamlRule.containsKey("labels")) {
                    TreeMap labels = new TreeMap((Map)yamlRule.get("labels"));
                    rule.labelNames = new ArrayList();
                    rule.labelValues = new ArrayList();
                    for (Map.Entry entry : labels.entrySet()) {
                        rule.labelNames.add((String)entry.getKey());
                        rule.labelValues.add((String)entry.getValue());
                    }
                }
                if ((rule.labelNames != null || rule.help != null) && rule.name == null) {
                    throw new IllegalArgumentException("Must provide name, if help or labels are given: " + yamlRule);
                }
                if (rule.name == null || rule.pattern != null) continue;
                throw new IllegalArgumentException("Must provide pattern, if name is given: " + yamlRule);
            }
        } else {
            cfg.rules.add(new Rule());
        }
        cfg.rulesCache = new MatchedRulesCache(cfg.rules);
        cfg.objectNameAttributeFilter = ObjectNameAttributeFilter.create(yamlConfig);
        return cfg;
    }

    static String toSnakeAndLowerCase(String attrName) {
        if (attrName == null || attrName.isEmpty()) {
            return attrName;
        }
        char firstChar = attrName.subSequence(0, 1).charAt(0);
        boolean prevCharIsUpperCaseOrUnderscore = Character.isUpperCase(firstChar) || firstChar == '_';
        StringBuilder resultBuilder = new StringBuilder(attrName.length()).append(Character.toLowerCase(firstChar));
        for (char attrChar : attrName.substring(1).toCharArray()) {
            boolean charIsUpperCase = Character.isUpperCase(attrChar);
            if (!prevCharIsUpperCaseOrUnderscore && charIsUpperCase) {
                resultBuilder.append("_");
            }
            resultBuilder.append(Character.toLowerCase(attrChar));
            prevCharIsUpperCaseOrUnderscore = charIsUpperCase || attrChar == '_';
        }
        return resultBuilder.toString();
    }

    static String safeName(String name) {
        if (name == null) {
            return null;
        }
        boolean prevCharIsUnderscore = false;
        StringBuilder safeNameBuilder = new StringBuilder(name.length());
        if (!name.isEmpty() && Character.isDigit(name.charAt(0))) {
            safeNameBuilder.append("_");
        }
        for (char nameChar : name.toCharArray()) {
            boolean isUnsafeChar;
            boolean bl = isUnsafeChar = !JmxCollector.isLegalCharacter(nameChar);
            if (isUnsafeChar || nameChar == '_') {
                if (prevCharIsUnderscore) continue;
                safeNameBuilder.append("_");
                prevCharIsUnderscore = true;
                continue;
            }
            safeNameBuilder.append(nameChar);
            prevCharIsUnderscore = false;
        }
        return safeNameBuilder.toString();
    }

    private static boolean isLegalCharacter(char input) {
        return input == ':' || input == '_' || input >= 'a' && input <= 'z' || input >= 'A' && input <= 'Z' || input >= '0' && input <= '9';
    }

    @Override
    public MetricSnapshots collect() {
        Config config = this.getLatestConfig();
        MatchedRulesCache.StalenessTracker stalenessTracker = new MatchedRulesCache.StalenessTracker();
        Receiver receiver = new Receiver(config, stalenessTracker);
        JmxScraper scraper = new JmxScraper(config.jmxUrl, config.username, config.password, config.ssl, config.includeObjectNames, config.excludeObjectNames, config.objectNameAttributeFilter, receiver, this.jmxMBeanPropertyCache);
        long start = System.nanoTime();
        double error = 0.0;
        if (config.startDelaySeconds > 0 && (start - this.createTimeNanoSecs) / 1000000000L < (long)config.startDelaySeconds.intValue()) {
            throw new IllegalStateException("JMXCollector waiting for startDelaySeconds");
        }
        try {
            scraper.doScrape();
        }
        catch (Exception e) {
            error = 1.0;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.log(Level.SEVERE, "JMX scrape failed: %s", sw);
        }
        config.rulesCache.evictStaleEntries(stalenessTracker);
        this.jmxScrapeDurationSeconds.set((double)(System.nanoTime() - start) / 1.0E9);
        this.jmxScrapeError.set(error);
        this.jmxScrapeCachedBeans.set(stalenessTracker.cachedCount());
        MetricSnapshots.Builder result = MetricSnapshots.builder();
        for (CounterSnapshot.Builder counter : receiver.countersMap.values()) {
            result.metricSnapshot(counter.build());
        }
        for (GaugeSnapshot.Builder gauge : receiver.gaugeMap.values()) {
            result.metricSnapshot(gauge.build());
        }
        for (UnknownSnapshot.Builder unknown : receiver.unknownMap.values()) {
            result.metricSnapshot(unknown.build());
        }
        return result.build();
    }

    public static enum Mode {
        AGENT,
        STANDALONE;

    }

    private static class Config {
        Integer startDelaySeconds = 0;
        String jmxUrl = "";
        String username = "";
        String password = "";
        boolean ssl = false;
        boolean lowercaseOutputName;
        boolean lowercaseOutputLabelNames;
        List<ObjectName> includeObjectNames = new ArrayList<ObjectName>();
        List<ObjectName> excludeObjectNames = new ArrayList<ObjectName>();
        ObjectNameAttributeFilter objectNameAttributeFilter;
        List<Rule> rules = new ArrayList<Rule>();
        long lastUpdate = 0L;
        MatchedRulesCache rulesCache;

        private Config() {
        }
    }

    static class Rule {
        Pattern pattern;
        String name;
        String value;
        Double valueFactor = 1.0;
        String help;
        boolean attrNameSnakeCase;
        boolean cache = false;
        String type = "UNKNOWN";
        ArrayList<String> labelNames;
        ArrayList<String> labelValues;

        Rule() {
        }
    }

    static class Receiver
    implements JmxScraper.MBeanReceiver {
        Map<String, UnknownSnapshot.Builder> unknownMap = new HashMap<String, UnknownSnapshot.Builder>();
        Map<String, CounterSnapshot.Builder> countersMap = new HashMap<String, CounterSnapshot.Builder>();
        Map<String, GaugeSnapshot.Builder> gaugeMap = new HashMap<String, GaugeSnapshot.Builder>();
        Config config;
        MatchedRulesCache.StalenessTracker stalenessTracker;
        private static final char SEP = '_';

        Receiver(Config config, MatchedRulesCache.StalenessTracker stalenessTracker) {
            this.config = config;
            this.stalenessTracker = stalenessTracker;
        }

        private String angleBrackets(String s) {
            return "<" + s.substring(1, s.length() - 1) + ">";
        }

        private void addToCache(Rule rule, String cacheKey, MatchedRule matchedRule) {
            if (rule.cache) {
                this.config.rulesCache.put(rule, cacheKey, matchedRule);
                this.stalenessTracker.add(rule, cacheKey);
            }
        }

        private MatchedRule defaultExport(String matchName, String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String help, Double value, double valueFactor, String type) {
            StringBuilder name = new StringBuilder();
            name.append(domain);
            if (beanProperties.size() > 0) {
                name.append('_');
                name.append(beanProperties.values().iterator().next());
            }
            for (String k : attrKeys) {
                name.append('_');
                name.append(k);
            }
            name.append('_');
            name.append(attrName);
            String fullname = JmxCollector.safeName(name.toString());
            if (this.config.lowercaseOutputName) {
                fullname = fullname.toLowerCase();
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            ArrayList<String> labelValues = new ArrayList<String>();
            if (beanProperties.size() > 1) {
                Iterator<Map.Entry<String, String>> iter = beanProperties.entrySet().iterator();
                iter.next();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String labelName = JmxCollector.safeName(entry.getKey());
                    if (this.config.lowercaseOutputLabelNames) {
                        labelName = labelName.toLowerCase();
                    }
                    labelNames.add(labelName);
                    labelValues.add(entry.getValue());
                }
            }
            return new MatchedRule(fullname, matchName, type, help, labelNames, labelValues, value, valueFactor);
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object beanValue) {
            Number value;
            String beanName = domain + this.angleBrackets(beanProperties.toString()) + this.angleBrackets(attrKeys.toString());
            String help = domain + ":name=" + beanProperties.get("name") + ",type=" + beanProperties.get("type") + ",attribute=" + attrName;
            if (attrDescription != null && !attrDescription.equals(attrName)) {
                help = attrDescription + " " + help;
            }
            MatchedRule matchedRule = MatchedRule.unmatched();
            for (Rule rule : this.config.rules) {
                MatchedRule cachedRule;
                Object matchBeanValue = rule.cache ? "<cache>" : beanValue;
                String attributeName = rule.attrNameSnakeCase ? JmxCollector.toSnakeAndLowerCase(attrName) : attrName;
                String matchName = beanName + attributeName + ": " + matchBeanValue;
                if (rule.cache && (cachedRule = this.config.rulesCache.get(rule, matchName)) != null) {
                    this.stalenessTracker.add(rule, matchName);
                    if (!cachedRule.isMatched()) continue;
                    matchedRule = cachedRule;
                    break;
                }
                Matcher matcher = null;
                if (rule.pattern != null && !(matcher = rule.pattern.matcher(matchName)).matches()) {
                    this.addToCache(rule, matchName, MatchedRule.unmatched());
                    continue;
                }
                Double value2 = null;
                if (rule.value != null && !rule.value.isEmpty()) {
                    String val = matcher.replaceAll(rule.value);
                    try {
                        value2 = Double.valueOf(val);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.log(Level.FINE, "Unable to parse configured value '%s' to number for bean: %s%s: %s", val, beanName, attrName, beanValue);
                        return;
                    }
                }
                if (rule.name == null) {
                    matchedRule = this.defaultExport(matchName, domain, beanProperties, attrKeys, attributeName, help, value2, rule.valueFactor, rule.type);
                    this.addToCache(rule, matchName, matchedRule);
                    break;
                }
                String name2 = JmxCollector.safeName(matcher.replaceAll(rule.name));
                if (name2.isEmpty()) {
                    return;
                }
                if (this.config.lowercaseOutputName) {
                    name2 = name2.toLowerCase();
                }
                if (rule.help != null) {
                    help = matcher.replaceAll(rule.help);
                }
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                if (rule.labelNames != null) {
                    for (int i = 0; i < rule.labelNames.size(); ++i) {
                        String unsafeLabelName = rule.labelNames.get(i);
                        String labelValReplacement = rule.labelValues.get(i);
                        try {
                            String labelName = JmxCollector.safeName(matcher.replaceAll(unsafeLabelName));
                            String labelValue = matcher.replaceAll(labelValReplacement);
                            if (this.config.lowercaseOutputLabelNames) {
                                labelName = labelName.toLowerCase();
                            }
                            if (labelName.isEmpty() || labelValue.isEmpty()) continue;
                            labelNames.add(labelName);
                            labelValues.add(labelValue);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Matcher '%s' unable to use: '%s' value: '%s'", matcher, unsafeLabelName, labelValReplacement), e);
                        }
                    }
                }
                matchedRule = new MatchedRule(name2, matchName, rule.type, help, labelNames, labelValues, value2, rule.valueFactor);
                this.addToCache(rule, matchName, matchedRule);
                break;
            }
            if (matchedRule.isUnmatched()) {
                return;
            }
            if (matchedRule.value != null) {
                beanValue = matchedRule.value;
            }
            if (beanValue instanceof Number) {
                value = ((Number)beanValue).doubleValue() * matchedRule.valueFactor;
            } else if (beanValue instanceof Boolean) {
                value = (Boolean)beanValue != false ? 1 : 0;
            } else {
                LOGGER.log(Level.FINE, "Ignoring unsupported bean: %s%s: %s ", beanName, attrName, beanValue);
                return;
            }
            LOGGER.log(Level.FINE, "add metric sample: %s %s %s %s", matchedRule.name, matchedRule.labelNames, matchedRule.labelValues, value.doubleValue());
            MatchedRule finalMatchedRule = matchedRule;
            switch (matchedRule.type) {
                case "COUNTER": {
                    CounterSnapshot.Builder counterBuilder = this.countersMap.computeIfAbsent(matchedRule.name, name -> (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(finalMatchedRule.name)).help(finalMatchedRule.help));
                    counterBuilder.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().value(value.doubleValue()).labels(Labels.of(finalMatchedRule.labelNames, finalMatchedRule.labelValues))).build());
                    break;
                }
                case "GAUGE": {
                    GaugeSnapshot.Builder gaugeBuilder = this.gaugeMap.computeIfAbsent(matchedRule.name, name -> (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(finalMatchedRule.name)).help(finalMatchedRule.help));
                    gaugeBuilder.dataPoint(((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().value(value.doubleValue()).labels(Labels.of(finalMatchedRule.labelNames, finalMatchedRule.labelValues))).build());
                    break;
                }
                default: {
                    UnknownSnapshot.Builder unknownBuilder = this.unknownMap.computeIfAbsent(matchedRule.name, name -> (UnknownSnapshot.Builder)((UnknownSnapshot.Builder)UnknownSnapshot.builder().name(finalMatchedRule.name)).help(finalMatchedRule.help));
                    unknownBuilder.dataPoint(((UnknownSnapshot.UnknownDataPointSnapshot.Builder)UnknownSnapshot.UnknownDataPointSnapshot.builder().value(value.doubleValue()).labels(Labels.of(finalMatchedRule.labelNames, finalMatchedRule.labelValues))).build());
                    break;
                }
            }
        }
    }
}

