/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.CounterMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.DoubleAdder;
import io.prometheus.jmx.shaded.io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Counter
extends SimpleCollector<Child>
implements Collector.Describable {
    Counter(Builder b) {
        super(b);
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void inc() {
        this.inc(1.0);
    }

    public void inc(double amt) {
        ((Child)this.noLabelsChild).inc(amt);
    }

    public double get() {
        return ((Child)this.noLabelsChild).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, (List)c.getKey(), ((Child)c.getValue()).get()));
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, Collector.Type.COUNTER, this.help, samples);
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.add(mfs);
        return mfsList;
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.add(new CounterMetricFamily(this.fullname, this.help, this.labelNames));
        return mfsList;
    }

    public static class Child {
        private final DoubleAdder value = new DoubleAdder();

        public void inc() {
            this.inc(1.0);
        }

        public void inc(double amt) {
            if (amt < 0.0) {
                throw new IllegalArgumentException("Amount to increment must be non-negative.");
            }
            this.value.add(amt);
        }

        public double get() {
            return this.value.sum();
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Counter> {
        @Override
        public Counter create() {
            return new Counter(this);
        }
    }
}

