/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.org.eclipse.jetty.security.authentication;

import io.prometheus.jmx.shaded.javax.servlet.ServletRequest;
import io.prometheus.jmx.shaded.javax.servlet.ServletResponse;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpServletRequest;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpServletResponse;
import io.prometheus.jmx.shaded.org.eclipse.jetty.security.ServerAuthException;
import io.prometheus.jmx.shaded.org.eclipse.jetty.security.UserAuthentication;
import io.prometheus.jmx.shaded.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import io.prometheus.jmx.shaded.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.Authentication;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.UserIdentity;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Log;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;

public class SpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(SpnegoAuthenticator.class);
    private String _authMethod = "SPNEGO";

    public SpnegoAuthenticator() {
    }

    public SpnegoAuthenticator(String authMethod) {
        this._authMethod = authMethod;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    @Override
    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        String spnegoToken;
        UserIdentity user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String header = req.getHeader("Authorization");
        if (!mandatory) {
            return this._deferred;
        }
        if (header == null) {
            try {
                if (DeferredAuthentication.isDeferred(res)) {
                    return Authentication.UNAUTHENTICATED;
                }
                LOG.debug("SpengoAuthenticator: sending challenge", new Object[0]);
                res.setHeader("WWW-Authenticate", "Negotiate");
                res.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException ioe) {
                throw new ServerAuthException(ioe);
            }
        }
        if (header != null && header.startsWith("Negotiate") && (user = this._loginService.login(null, spnegoToken = header.substring(10))) != null) {
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        return Authentication.UNAUTHENTICATED;
    }

    @Override
    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

