/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.org.eclipse.jetty.util.log;

import io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Log;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Logger;

public abstract class AbstractLogger
implements Logger {
    @Override
    public final Logger getLogger(String name) {
        if (AbstractLogger.isBlank(name)) {
            return this;
        }
        String basename = this.getName();
        String fullname = AbstractLogger.isBlank(basename) || Log.getRootLogger() == this ? name : basename + "." + name;
        Logger logger = Log.getLoggers().get(fullname);
        if (logger == null) {
            Logger newlog = this.newLogger(fullname);
            logger = Log.getMutableLoggers().putIfAbsent(fullname, newlog);
            if (logger == null) {
                logger = newlog;
            }
        }
        return logger;
    }

    protected abstract Logger newLogger(String var1);

    private static boolean isBlank(String name) {
        if (name == null) {
            return true;
        }
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }
}

