/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.org.eclipse.jetty.server;

import io.prometheus.jmx.shaded.javax.servlet.AsyncContext;
import io.prometheus.jmx.shaded.javax.servlet.AsyncListener;
import io.prometheus.jmx.shaded.javax.servlet.DispatcherType;
import io.prometheus.jmx.shaded.javax.servlet.MultipartConfigElement;
import io.prometheus.jmx.shaded.javax.servlet.RequestDispatcher;
import io.prometheus.jmx.shaded.javax.servlet.ServletContext;
import io.prometheus.jmx.shaded.javax.servlet.ServletException;
import io.prometheus.jmx.shaded.javax.servlet.ServletInputStream;
import io.prometheus.jmx.shaded.javax.servlet.ServletRequest;
import io.prometheus.jmx.shaded.javax.servlet.ServletRequestAttributeEvent;
import io.prometheus.jmx.shaded.javax.servlet.ServletRequestAttributeListener;
import io.prometheus.jmx.shaded.javax.servlet.ServletResponse;
import io.prometheus.jmx.shaded.javax.servlet.http.Cookie;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpServletRequest;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpServletResponse;
import io.prometheus.jmx.shaded.javax.servlet.http.HttpSession;
import io.prometheus.jmx.shaded.javax.servlet.http.Part;
import io.prometheus.jmx.shaded.org.eclipse.jetty.continuation.ContinuationListener;
import io.prometheus.jmx.shaded.org.eclipse.jetty.http.HttpCookie;
import io.prometheus.jmx.shaded.org.eclipse.jetty.http.HttpFields;
import io.prometheus.jmx.shaded.org.eclipse.jetty.http.HttpHeaders;
import io.prometheus.jmx.shaded.org.eclipse.jetty.http.HttpParser;
import io.prometheus.jmx.shaded.org.eclipse.jetty.http.HttpURI;
import io.prometheus.jmx.shaded.org.eclipse.jetty.http.MimeTypes;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.Buffer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.BufferUtil;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.ByteArrayBuffer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.EndPoint;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.nio.DirectNIOBuffer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.nio.NIOBuffer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.AbstractHttpConnection;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.AsyncContinuation;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.Authentication;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.CookieCutter;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.Response;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.SessionManager;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.UserIdentity;
import io.prometheus.jmx.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.Attributes;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.AttributesMap;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.LazyList;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.MultiMap;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.MultiPartInputStream;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.StringUtil;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.URIUtil;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.UrlEncoded;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Log;
import io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Request
implements HttpServletRequest {
    public static final String __MULTIPART_CONFIG_ELEMENT = "io.prometheus.jmx.shaded.org.eclipse.multipartConfig";
    private static final Logger LOG = Log.getLogger(Request.class);
    private static final String __ASYNC_FWD = "io.prometheus.jmx.shaded.org.eclipse.asyncfwd";
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int __NONE = 0;
    private static final int _STREAM = 1;
    private static final int __READER = 2;
    protected final AsyncContinuation _async = new AsyncContinuation();
    private boolean _asyncSupported = true;
    private volatile Attributes _attributes;
    private Authentication _authentication;
    private MultiMap<String> _baseParameters;
    private String _characterEncoding;
    protected AbstractHttpConnection _connection;
    private ContextHandler.Context _context;
    private boolean _newContext;
    private String _contextPath;
    private CookieCutter _cookies;
    private boolean _cookiesExtracted = false;
    private DispatcherType _dispatcherType;
    private boolean _dns = false;
    private EndPoint _endp;
    private boolean _handled = false;
    private int _inputState = 0;
    private String _method;
    private MultiMap<String> _parameters;
    private boolean _paramsExtracted;
    private String _pathInfo;
    private int _port;
    private String _protocol = "HTTP/1.1";
    private String _queryEncoding;
    private String _queryString;
    private BufferedReader _reader;
    private String _readerEncoding;
    private String _remoteAddr;
    private String _remoteHost;
    private Object _requestAttributeListeners;
    private String _requestedSessionId;
    private boolean _requestedSessionIdFromCookie = false;
    private String _requestURI;
    private Map<Object, HttpSession> _savedNewSessions;
    private String _scheme = "http";
    private UserIdentity.Scope _scope;
    private String _serverName;
    private String _servletPath;
    private HttpSession _session;
    private SessionManager _sessionManager;
    private long _timeStamp;
    private long _dispatchTime;
    private Buffer _timeStampBuffer;
    private HttpURI _uri;
    private MultiPartInputStream _multiPartInputStream;

    public static Request getRequest(HttpServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        return AbstractHttpConnection.getCurrentConnection().getRequest();
    }

    public Request() {
    }

    public Request(AbstractHttpConnection connection) {
        this.setConnection(connection);
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
        if (listener instanceof ContinuationListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractParameters() {
        if (this._baseParameters == null) {
            this._baseParameters = new MultiMap(16);
        }
        if (this._paramsExtracted) {
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            }
            return;
        }
        this._paramsExtracted = true;
        try {
            int content_length;
            if (this._uri != null && this._uri.hasQuery()) {
                if (this._queryEncoding == null) {
                    this._uri.decodeQueryTo(this._baseParameters);
                } else {
                    try {
                        this._uri.decodeQueryTo(this._baseParameters, this._queryEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn(e);
                        }
                        LOG.warn(e.toString(), new Object[0]);
                    }
                }
            }
            String encoding = this.getCharacterEncoding();
            String content_type = this.getContentType();
            if (content_type != null && content_type.length() > 0 && "application/x-www-form-urlencoded".equalsIgnoreCase(content_type = HttpFields.valueParameters(content_type, null)) && this._inputState == 0 && ("POST".equals(this.getMethod()) || "PUT".equals(this.getMethod())) && (content_length = this.getContentLength()) != 0) {
                try {
                    int maxFormContentSize = -1;
                    int maxFormKeys = -1;
                    if (this._context != null) {
                        maxFormContentSize = this._context.getContextHandler().getMaxFormContentSize();
                        maxFormKeys = this._context.getContextHandler().getMaxFormKeys();
                    } else {
                        Number size = (Number)this._connection.getConnector().getServer().getAttribute("io.prometheus.jmx.shaded.org.eclipse.jetty.server.Request.maxFormContentSize");
                        maxFormContentSize = size == null ? 200000 : size.intValue();
                        Number keys = (Number)this._connection.getConnector().getServer().getAttribute("io.prometheus.jmx.shaded.org.eclipse.jetty.server.Request.maxFormKeys");
                        int n = maxFormKeys = keys == null ? 1000 : keys.intValue();
                    }
                    if (content_length > maxFormContentSize && maxFormContentSize > 0) {
                        throw new IllegalStateException("Form too large" + content_length + ">" + maxFormContentSize);
                    }
                    ServletInputStream in = this.getInputStream();
                    UrlEncoded.decodeTo(in, this._baseParameters, encoding, content_length < 0 ? maxFormContentSize : -1, maxFormKeys);
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(e);
                    }
                    LOG.warn(e.toString(), new Object[0]);
                }
            }
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            } else if (this._parameters != this._baseParameters) {
                for (Map.Entry<String, Object> entry : this._baseParameters.entrySet()) {
                    String name = entry.getKey();
                    Object values = entry.getValue();
                    for (int i = 0; i < LazyList.size(values); ++i) {
                        this._parameters.add(name, LazyList.get(values, i));
                    }
                }
            }
        }
        finally {
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            }
        }
    }

    @Override
    public AsyncContext getAsyncContext() {
        if (this._async.isInitial() && !this._async.isAsyncStarted()) {
            throw new IllegalStateException(this._async.getStatusString());
        }
        return this._async;
    }

    public AsyncContinuation getAsyncContinuation() {
        return this._async;
    }

    @Override
    public Object getAttribute(String name) {
        Object attr;
        if ("io.prometheus.jmx.shaded.org.eclipse.jetty.io.EndPoint.maxIdleTime".equalsIgnoreCase(name)) {
            return new Long(this.getConnection().getEndPoint().getMaxIdleTime());
        }
        Object object = attr = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (attr == null && "io.prometheus.jmx.shaded.org.eclipse.jetty.continuation".equals(name)) {
            return this._async;
        }
        return attr;
    }

    public Enumeration getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        return this._attributes;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    @Override
    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate(this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public AbstractHttpConnection getConnection() {
        return this._connection;
    }

    @Override
    public int getContentLength() {
        return (int)this._connection.getRequestFields().getLongField(HttpHeaders.CONTENT_LENGTH_BUFFER);
    }

    public long getContentRead() {
        if (this._connection == null || this._connection.getParser() == null) {
            return -1L;
        }
        return ((HttpParser)this._connection.getParser()).getContentRead();
    }

    @Override
    public String getContentType() {
        return this._connection.getRequestFields().getStringField(HttpHeaders.CONTENT_TYPE_BUFFER);
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    @Override
    public String getContextPath() {
        return this._contextPath;
    }

    @Override
    public Cookie[] getCookies() {
        if (this._cookiesExtracted) {
            return this._cookies == null ? null : this._cookies.getCookies();
        }
        this._cookiesExtracted = true;
        Enumeration<String> enm = this._connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
        if (enm != null) {
            if (this._cookies == null) {
                this._cookies = new CookieCutter();
            }
            while (enm.hasMoreElements()) {
                String c = enm.nextElement();
                this._cookies.addCookieField(c);
            }
        }
        return this._cookies == null ? null : this._cookies.getCookies();
    }

    @Override
    public long getDateHeader(String name) {
        return this._connection.getRequestFields().getDateField(name);
    }

    @Override
    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }

    @Override
    public String getHeader(String name) {
        return this._connection.getRequestFields().getStringField(name);
    }

    public Enumeration getHeaderNames() {
        return this._connection.getRequestFields().getFieldNames();
    }

    public Enumeration getHeaders(String name) {
        Enumeration<String> e = this._connection.getRequestFields().getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return e;
    }

    public int getInputState() {
        return this._inputState;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        return this._connection.getInputStream();
    }

    @Override
    public int getIntHeader(String name) {
        return (int)this._connection.getRequestFields().getLongField(name);
    }

    @Override
    public String getLocalAddr() {
        return this._endp == null ? null : this._endp.getLocalAddr();
    }

    @Override
    public Locale getLocale() {
        Enumeration<String> enm = this._connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Locale.getDefault();
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int size = acceptLanguage.size();
        if (size > 0) {
            String language = (String)acceptLanguage.get(0);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Enumeration<String> enm = this._connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        Object langs = null;
        int size = acceptLanguage.size();
        for (int i = 0; i < size; ++i) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, size);
            langs = LazyList.add(langs, new Locale(language, country));
        }
        if (LazyList.size(langs) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(langs));
    }

    @Override
    public String getLocalName() {
        if (this._endp == null) {
            return null;
        }
        if (this._dns) {
            return this._endp.getLocalHost();
        }
        String local = this._endp.getLocalAddr();
        if (local != null && local.indexOf(58) >= 0) {
            local = "[" + local + "]";
        }
        return local;
    }

    @Override
    public int getLocalPort() {
        return this._endp == null ? 0 : this._endp.getLocalPort();
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public String getParameter(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(name, 0);
    }

    public Map getParameterMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.unmodifiableMap(this._parameters.toStringArrayMap());
    }

    public Enumeration getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.enumeration(this._parameters.keySet());
    }

    public MultiMap<String> getParameters() {
        return this._parameters;
    }

    @Override
    public String[] getParameterValues(String name) {
        List vals;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if ((vals = this._parameters.getValues(name)) == null) {
            return null;
        }
        return vals.toArray(new String[vals.size()]);
    }

    @Override
    public String getPathInfo() {
        return this._pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(this._pathInfo);
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    public String getQueryEncoding() {
        return this._queryEncoding;
    }

    @Override
    public String getQueryString() {
        if (this._queryString == null && this._uri != null) {
            this._queryString = this._queryEncoding == null ? this._uri.getQuery() : this._uri.getQuery(this._queryEncoding);
        }
        return this._queryString;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        if (this._reader == null || !encoding.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)in, encoding)){

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    @Override
    public String getRealPath(String path) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(path);
    }

    @Override
    public String getRemoteAddr() {
        if (this._remoteAddr != null) {
            return this._remoteAddr;
        }
        return this._endp == null ? null : this._endp.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        if (this._dns) {
            if (this._remoteHost != null) {
                return this._remoteHost;
            }
            return this._endp == null ? null : this._endp.getRemoteHost();
        }
        return this.getRemoteAddr();
    }

    @Override
    public int getRemotePort() {
        return this._endp == null ? 0 : this._endp.getRemotePort();
    }

    @Override
    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || this._context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = URIUtil.addPaths(this._servletPath, this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths(relTo, path);
        }
        return this._context.getRequestDispatcher(path);
    }

    @Override
    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    @Override
    public String getRequestURI() {
        if (this._requestURI == null && this._uri != null) {
            this._requestURI = this._uri.getPathAndParam();
        }
        return this._requestURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer getRequestURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer(48);
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (this._port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
                url.append(':');
                url.append(this._port);
            }
            url.append(this.getRequestURI());
            return url;
        }
    }

    public Response getResponse() {
        return this._connection._response;
    }

    public StringBuilder getRootURL() {
        StringBuilder url = new StringBuilder(48);
        String scheme = this.getScheme();
        int port = this.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        return url;
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    @Override
    public String getServerName() {
        if (this._serverName != null) {
            return this._serverName;
        }
        if (this._uri == null) {
            throw new IllegalStateException("No uri");
        }
        this._serverName = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._serverName != null) {
            return this._serverName;
        }
        Buffer hostPort = this._connection.getRequestFields().get(HttpHeaders.HOST_BUFFER);
        if (hostPort != null) {
            int i = hostPort.putIndex();
            block10: while (i-- > hostPort.getIndex()) {
                char ch = (char)(0xFF & hostPort.peek(i));
                switch (ch) {
                    case ']': {
                        break block10;
                    }
                    case ':': {
                        this._serverName = BufferUtil.to8859_1_String(hostPort.peek(hostPort.getIndex(), i - hostPort.getIndex()));
                        try {
                            this._port = BufferUtil.toInt(hostPort.peek(i + 1, hostPort.putIndex() - i - 1));
                        }
                        catch (NumberFormatException e) {
                            try {
                                if (this._connection != null) {
                                    this._connection._generator.sendError(400, "Bad Host header", null, true);
                                }
                            }
                            catch (IOException e1) {
                                throw new RuntimeException(e1);
                            }
                        }
                        return this._serverName;
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            if (this._serverName == null || this._port < 0) {
                this._serverName = BufferUtil.to8859_1_String(hostPort);
                this._port = 0;
            }
            return this._serverName;
        }
        if (this._connection != null) {
            this._serverName = this.getLocalName();
            this._port = this.getLocalPort();
            if (this._serverName != null && !"0.0.0.0".equals(this._serverName)) {
                return this._serverName;
            }
        }
        try {
            this._serverName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.ignore(e);
        }
        return this._serverName;
    }

    @Override
    public int getServerPort() {
        if (this._port <= 0) {
            if (this._serverName == null) {
                this.getServerName();
            }
            if (this._port <= 0) {
                if (this._serverName != null && this._uri != null) {
                    this._port = this._uri.getPort();
                } else {
                    int n = this._port = this._endp == null ? 0 : this._endp.getLocalPort();
                }
            }
        }
        if (this._port <= 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this._port;
    }

    @Override
    public ServletContext getServletContext() {
        return this._context;
    }

    public String getServletName() {
        if (this._scope != null) {
            return this._scope.getName();
        }
        return null;
    }

    @Override
    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public ServletResponse getServletResponse() {
        return this._connection.getResponse();
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._sessionManager != null && !this._sessionManager.isValid(this._session)) {
                this._session = null;
            } else {
                return this._session;
            }
        }
        if (!create) {
            return null;
        }
        if (this._sessionManager == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._session = this._sessionManager.newHttpSession(this);
        HttpCookie cookie = this._sessionManager.getSessionCookie(this._session, this.getContextPath(), this.isSecure());
        if (cookie != null) {
            this._connection.getResponse().addCookie(cookie);
        }
        return this._session;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public Buffer getTimeStampBuffer() {
        if (this._timeStampBuffer == null && this._timeStamp > 0L) {
            this._timeStampBuffer = HttpFields.__dateCache.formatBuffer(this._timeStamp);
        }
        return this._timeStampBuffer;
    }

    public HttpURI getUri() {
        return this._uri;
    }

    public UserIdentity getUserIdentity() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate(this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity getResolvedUserIdentity() {
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity.Scope getUserIdentityScope() {
        return this._scope;
    }

    @Override
    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate(this));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity user = ((Authentication.User)this._authentication).getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public long getDispatchTime() {
        return this._dispatchTime;
    }

    public boolean isHandled() {
        return this._handled;
    }

    @Override
    public boolean isAsyncStarted() {
        return this._async.isAsyncStarted();
    }

    @Override
    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this._requestedSessionId == null) {
            return false;
        }
        HttpSession session = this.getSession(false);
        return session != null && this._sessionManager.getSessionIdManager().getClusterId(this._requestedSessionId).equals(this._sessionManager.getClusterId(session));
    }

    @Override
    public boolean isSecure() {
        return this._connection.isConfidential(this);
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate(this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).isUserInRole(this._scope, role);
        }
        return false;
    }

    public HttpSession recoverNewSession(Object key) {
        if (this._savedNewSessions == null) {
            return null;
        }
        return this._savedNewSessions.get(key);
    }

    protected void recycle() {
        if (this._inputState == 2) {
            try {
                int r = this._reader.read();
                while (r != -1) {
                    r = this._reader.read();
                }
            }
            catch (Exception e) {
                LOG.ignore(e);
                this._reader = null;
            }
        }
        this.setAuthentication(Authentication.NOT_CHECKED);
        this._async.recycle();
        this._asyncSupported = true;
        this._handled = false;
        if (this._context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this._attributes != null) {
            this._attributes.clearAttributes();
        }
        this._characterEncoding = null;
        this._contextPath = null;
        if (this._cookies != null) {
            this._cookies.reset();
        }
        this._cookiesExtracted = false;
        this._context = null;
        this._serverName = null;
        this._method = null;
        this._pathInfo = null;
        this._port = 0;
        this._protocol = "HTTP/1.1";
        this._queryEncoding = null;
        this._queryString = null;
        this._requestedSessionId = null;
        this._requestedSessionIdFromCookie = false;
        this._session = null;
        this._sessionManager = null;
        this._requestURI = null;
        this._scope = null;
        this._scheme = "http";
        this._servletPath = null;
        this._timeStamp = 0L;
        this._timeStampBuffer = null;
        this._uri = null;
        if (this._baseParameters != null) {
            this._baseParameters.clear();
        }
        this._parameters = null;
        this._paramsExtracted = false;
        this._inputState = 0;
        if (this._savedNewSessions != null) {
            this._savedNewSessions.clear();
        }
        this._savedNewSessions = null;
        this._multiPartInputStream = null;
    }

    @Override
    public void removeAttribute(String name) {
        Object old_value;
        Object object = old_value = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
        if (old_value != null && this._requestAttributeListeners != null) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this._context, this, name, old_value);
            int size = LazyList.size(this._requestAttributeListeners);
            for (int i = 0; i < size; ++i) {
                ServletRequestAttributeListener listener = (ServletRequestAttributeListener)LazyList.get(this._requestAttributeListeners, i);
                if (!(listener instanceof ServletRequestAttributeListener)) continue;
                ServletRequestAttributeListener l = listener;
                l.attributeRemoved(event);
            }
        }
    }

    public void removeEventListener(EventListener listener) {
        this._requestAttributeListeners = LazyList.remove(this._requestAttributeListeners, listener);
    }

    public void saveNewSession(Object key, HttpSession session) {
        if (this._savedNewSessions == null) {
            this._savedNewSessions = new HashMap<Object, HttpSession>();
        }
        this._savedNewSessions.put(key, session);
    }

    public void setAsyncSupported(boolean supported) {
        this._asyncSupported = supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        Object old_value;
        block20: {
            Object object = old_value = this._attributes == null ? null : this._attributes.getAttribute(name);
            if (name.startsWith("io.prometheus.jmx.shaded.org.eclipse.jetty.")) {
                if ("io.prometheus.jmx.shaded.org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
                    this.setQueryEncoding(value == null ? null : value.toString());
                } else {
                    if ("io.prometheus.jmx.shaded.org.eclipse.jetty.server.sendContent".equals(name)) {
                        try {
                            ((AbstractHttpConnection.Output)this.getServletResponse().getOutputStream()).sendContent(value);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if ("io.prometheus.jmx.shaded.org.eclipse.jetty.server.ResponseBuffer".equals(name)) {
                        try {
                            ByteBuffer byteBuffer;
                            ByteBuffer byteBuffer2 = byteBuffer = (ByteBuffer)value;
                            synchronized (byteBuffer2) {
                                NIOBuffer buffer = (NIOBuffer)((Object)(byteBuffer.isDirect() ? new DirectNIOBuffer(byteBuffer, true) : new IndirectNIOBuffer(byteBuffer, true)));
                                ((AbstractHttpConnection.Output)this.getServletResponse().getOutputStream()).sendResponse(buffer);
                                break block20;
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if ("io.prometheus.jmx.shaded.org.eclipse.jetty.io.EndPoint.maxIdleTime".equalsIgnoreCase(name)) {
                        try {
                            this.getConnection().getEndPoint().setMaxIdleTime(Integer.valueOf(value.toString()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(name, value);
        if (this._requestAttributeListeners != null) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this._context, this, name, old_value == null ? value : old_value);
            int size = LazyList.size(this._requestAttributeListeners);
            for (int i = 0; i < size; ++i) {
                ServletRequestAttributeListener listener = (ServletRequestAttributeListener)LazyList.get(this._requestAttributeListeners, i);
                if (!(listener instanceof ServletRequestAttributeListener)) continue;
                ServletRequestAttributeListener l = listener;
                if (old_value == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = encoding;
        if (!StringUtil.isUTF8(encoding)) {
            "".getBytes(encoding);
        }
    }

    public void setCharacterEncodingUnchecked(String encoding) {
        this._characterEncoding = encoding;
    }

    protected final void setConnection(AbstractHttpConnection connection) {
        this._connection = connection;
        this._async.setConnection(connection);
        this._endp = connection.getEndPoint();
        this._dns = connection.getResolveNames();
    }

    public void setContentType(String contentType) {
        this._connection.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType);
    }

    public void setContext(ContextHandler.Context context) {
        this._newContext = this._context != context;
        this._context = context;
    }

    public boolean takeNewContext() {
        boolean nc = this._newContext;
        this._newContext = false;
        return nc;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setCookies(Cookie[] cookies) {
        if (this._cookies == null) {
            this._cookies = new CookieCutter();
        }
        this._cookies.setCookies(cookies);
    }

    public void setDispatcherType(DispatcherType type) {
        this._dispatcherType = type;
    }

    public void setHandled(boolean h) {
        this._handled = h;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setParameters(MultiMap<String> parameters) {
        MultiMap<String> multiMap = this._parameters = parameters == null ? this._baseParameters : parameters;
        if (this._paramsExtracted && this._parameters == null) {
            throw new IllegalStateException();
        }
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = queryEncoding;
        this._queryString = null;
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString;
    }

    public void setRemoteAddr(String addr) {
        this._remoteAddr = addr;
    }

    public void setRemoteHost(String host) {
        this._remoteHost = host;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this._requestedSessionId = requestedSessionId;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdCookie) {
        this._requestedSessionIdFromCookie = requestedSessionIdCookie;
    }

    public void setRequestURI(String requestURI) {
        this._requestURI = requestURI;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public void setServerName(String host) {
        this._serverName = host;
    }

    public void setServerPort(int port) {
        this._port = port;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void setSession(HttpSession session) {
        this._session = session;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public void setUri(HttpURI uri) {
        this._uri = uri;
    }

    public void setUserIdentityScope(UserIdentity.Scope scope) {
        this._scope = scope;
    }

    public void setDispatchTime(long value) {
        this._dispatchTime = value;
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        if (!this._asyncSupported) {
            throw new IllegalStateException("!asyncSupported");
        }
        this._async.suspend();
        return this._async;
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this._asyncSupported) {
            throw new IllegalStateException("!asyncSupported");
        }
        this._async.suspend(this._context, servletRequest, servletResponse);
        return this._async;
    }

    public String toString() {
        return (this._handled ? "[" : "(") + this.getMethod() + " " + this._uri + (this._handled ? "]@" : ")@") + this.hashCode() + " " + super.toString();
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate(this, response));
            return !(this._authentication instanceof Authentication.ResponseSent);
        }
        response.sendError(401);
        return false;
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        if (this.getContentType() == null || !this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type != multipart/form-data");
        }
        if (this._multiPartInputStream == null) {
            this._multiPartInputStream = new MultiPartInputStream(this.getInputStream(), this.getContentType(), (MultipartConfigElement)this.getAttribute(__MULTIPART_CONFIG_ELEMENT), this._context != null ? (File)this._context.getAttribute("io.prometheus.jmx.shaded.javax.servlet.context.tempdir") : null);
            Collection<Part> parts = this._multiPartInputStream.getParts();
            for (Part p : parts) {
                MultiPartInputStream.MultiPart mp = (MultiPartInputStream.MultiPart)p;
                if (mp.getContentDispositionFilename() != null || mp.getFile() != null) continue;
                String charset = null;
                if (mp.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType(new ByteArrayBuffer(mp.getContentType()));
                }
                String content = new String(mp.getBytes(), charset == null ? "UTF-8" : charset);
                this.getParameter("");
                this.getParameters().add(mp.getName(), content);
            }
        }
        return this._multiPartInputStream.getPart(name);
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.getContentType() == null || !this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type != multipart/form-data");
        }
        if (this._multiPartInputStream == null) {
            this._multiPartInputStream = new MultiPartInputStream(this.getInputStream(), this.getContentType(), (MultipartConfigElement)this.getAttribute(__MULTIPART_CONFIG_ELEMENT), this._context != null ? (File)this._context.getAttribute("io.prometheus.jmx.shaded.javax.servlet.context.tempdir") : null);
            Collection<Part> parts = this._multiPartInputStream.getParts();
            for (Part p : parts) {
                MultiPartInputStream.MultiPart mp = (MultiPartInputStream.MultiPart)p;
                if (mp.getContentDispositionFilename() != null || mp.getFile() != null) continue;
                String charset = null;
                if (mp.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType(new ByteArrayBuffer(mp.getContentType()));
                }
                String content = new String(mp.getBytes(), charset == null ? "UTF-8" : charset);
                this.getParameter("");
                this.getParameters().add(mp.getName(), content);
            }
        }
        return this._multiPartInputStream.getParts();
    }

    @Override
    public void login(String username, String password) throws ServletException {
        if (this._authentication instanceof Authentication.Deferred) {
            this._authentication = ((Authentication.Deferred)this._authentication).login(username, password);
            if (this._authentication == null) {
                throw new ServletException();
            }
        } else {
            throw new ServletException("Authenticated as " + this._authentication);
        }
    }

    @Override
    public void logout() throws ServletException {
        if (this._authentication instanceof Authentication.User) {
            ((Authentication.User)this._authentication).logout();
        }
        this._authentication = Authentication.UNAUTHENTICATED;
    }

    public void mergeQueryString(String query) {
        MultiMap<String> parameters = new MultiMap<String>();
        UrlEncoded.decodeTo(query, parameters, this.getCharacterEncoding());
        boolean merge_old_query = false;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if (this._parameters != null && this._parameters.size() > 0) {
            for (Map.Entry<String, Object> entry : this._parameters.entrySet()) {
                String name = entry.getKey();
                if (parameters.containsKey(name)) {
                    merge_old_query = true;
                }
                Object values = entry.getValue();
                for (int i = 0; i < LazyList.size(values); ++i) {
                    parameters.add(name, LazyList.get(values, i));
                }
            }
        }
        if (this._queryString != null && this._queryString.length() > 0) {
            if (merge_old_query) {
                StringBuilder overridden_query_string = new StringBuilder();
                MultiMap overridden_old_query = new MultiMap();
                UrlEncoded.decodeTo(this._queryString, overridden_old_query, this.getCharacterEncoding());
                MultiMap overridden_new_query = new MultiMap();
                UrlEncoded.decodeTo(query, overridden_new_query, this.getCharacterEncoding());
                for (Map.Entry entry : overridden_old_query.entrySet()) {
                    String name = (String)entry.getKey();
                    if (overridden_new_query.containsKey(name)) continue;
                    Object values = entry.getValue();
                    for (int i = 0; i < LazyList.size(values); ++i) {
                        overridden_query_string.append("&").append(name).append("=").append(LazyList.get(values, i));
                    }
                }
                query = query + overridden_query_string;
            } else {
                query = query + "&" + this._queryString;
            }
        }
        this.setParameters(parameters);
        this.setQueryString(query);
    }
}

