/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.jmx;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.jmx.JmxScraper;
import io.prometheus.jmx.shaded.org.json.simple.JSONArray;
import io.prometheus.jmx.shaded.org.json.simple.JSONObject;
import io.prometheus.jmx.shaded.org.json.simple.parser.JSONParser;
import io.prometheus.jmx.shaded.org.json.simple.parser.ParseException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxCollector
extends Collector {
    private static final Logger LOGGER = Logger.getLogger(JmxCollector.class.getName());
    String hostPort;
    boolean lowercaseOutputName;
    boolean lowercaseOutputLabelNames;
    ArrayList<Rule> rules = new ArrayList();

    public JmxCollector(Reader in) throws IOException, ParseException {
        this((JSONObject)new JSONParser().parse(in));
    }

    public JmxCollector(String jsonConfig) throws ParseException {
        this((JSONObject)new JSONParser().parse(jsonConfig));
    }

    private JmxCollector(JSONObject config) throws ParseException {
        this.hostPort = config.containsKey("hostPort") ? (String)config.get("hostPort") : "";
        if (config.containsKey("lowercaseOutputName")) {
            this.lowercaseOutputName = (Boolean)config.get("lowercaseOutputName");
        }
        if (config.containsKey("lowercaseOutputLabelNames")) {
            this.lowercaseOutputLabelNames = (Boolean)config.get("lowercaseOutputLabelNames");
        }
        if (config.containsKey("rules")) {
            JSONArray configRules = (JSONArray)config.get("rules");
            for (Object ruleObject : configRules) {
                JSONObject jsonRule = (JSONObject)ruleObject;
                Rule rule = new Rule();
                this.rules.add(rule);
                if (jsonRule.containsKey("pattern")) {
                    rule.pattern = Pattern.compile("^.*" + (String)jsonRule.get("pattern") + ".*$");
                }
                if (jsonRule.containsKey("name")) {
                    rule.name = (String)jsonRule.get("name");
                }
                if (jsonRule.containsKey("attrNameSnakeCase")) {
                    rule.attrNameSnakeCase = (Boolean)jsonRule.get("attrNameSnakeCase");
                }
                if (jsonRule.containsKey("type")) {
                    rule.type = Collector.Type.valueOf((String)jsonRule.get("type"));
                }
                if (jsonRule.containsKey("help")) {
                    rule.help = (String)jsonRule.get("help");
                }
                if (jsonRule.containsKey("labels")) {
                    TreeMap labels = new TreeMap((JSONObject)jsonRule.get("labels"));
                    rule.labelNames = new ArrayList();
                    rule.labelValues = new ArrayList();
                    for (Map.Entry entry : labels.entrySet()) {
                        rule.labelNames.add((String)entry.getKey());
                        rule.labelValues.add((String)entry.getValue());
                    }
                }
                if ((rule.labelNames != null || rule.help != null) && rule.name == null) {
                    throw new IllegalArgumentException("Must provide name, if help or labels are given: " + jsonRule);
                }
                if (rule.name == null || rule.pattern != null) continue;
                throw new IllegalArgumentException("Must provide pattern, if name is given: " + jsonRule);
            }
        } else {
            this.rules.add(new Rule());
        }
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        Receiver receiver = new Receiver();
        JmxScraper scraper = new JmxScraper(this.hostPort, receiver);
        long start = System.nanoTime();
        double error = 0.0;
        try {
            scraper.doScrape();
        }
        catch (Exception e) {
            error = 1.0;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.severe("JMX scrape failed: " + sw.toString());
        }
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.addAll(receiver.metricFamilySamplesMap.values());
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_duration_seconds", new ArrayList<String>(), new ArrayList<String>(), (double)(System.nanoTime() - start) / 1.0E9));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_error", new ArrayList<String>(), new ArrayList<String>(), error));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", samples));
        return mfsList;
    }

    public static void main(String[] args) throws Exception {
        String hostPort = "";
        if (args.length > 0) {
            hostPort = args[0];
        }
        JmxCollector jc = new JmxCollector(("{`hostPort`: `" + hostPort + "`," + "}").replace('`', '\"'));
        for (Collector.MetricFamilySamples mfs : jc.collect()) {
            System.out.println(mfs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Receiver
    implements JmxScraper.MBeanReceiver {
        Map<String, Collector.MetricFamilySamples> metricFamilySamplesMap = new HashMap<String, Collector.MetricFamilySamples>();
        private static final char SEP = '_';

        Receiver() {
        }

        private String angleBrackets(String s) {
            return "<" + s.substring(1, s.length() - 1) + ">";
        }

        private String safeName(String s) {
            return s.replaceAll("[^a-zA-Z0-9:_]", "_").replaceAll("__+", "_");
        }

        void addSample(Collector.MetricFamilySamples.Sample sample, Collector.Type type, String help) {
            Collector.MetricFamilySamples mfs = this.metricFamilySamplesMap.get(sample.name);
            if (mfs == null) {
                mfs = new Collector.MetricFamilySamples(sample.name, type, help, new ArrayList<Collector.MetricFamilySamples.Sample>());
                this.metricFamilySamplesMap.put(sample.name, mfs);
            }
            mfs.samples.add(sample);
        }

        private void defaultExport(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String help, Object value) {
            StringBuilder name = new StringBuilder();
            name.append(domain);
            if (beanProperties.size() > 0) {
                name.append('_');
                name.append(beanProperties.values().iterator().next());
            }
            for (String k : attrKeys) {
                name.append('_');
                name.append(k);
            }
            name.append('_');
            name.append(attrName);
            String fullname = this.safeName(name.toString());
            if (JmxCollector.this.lowercaseOutputName) {
                fullname = fullname.toLowerCase();
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            ArrayList<String> labelValues = new ArrayList<String>();
            if (beanProperties.size() > 1) {
                Iterator<Map.Entry<String, String>> iter = beanProperties.entrySet().iterator();
                iter.next();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String labelName = this.safeName(entry.getKey());
                    if (JmxCollector.this.lowercaseOutputLabelNames) {
                        labelName = labelName.toLowerCase();
                    }
                    labelNames.add(labelName);
                    labelValues.add(entry.getValue());
                }
            }
            this.addSample(new Collector.MetricFamilySamples.Sample(fullname, labelNames, labelValues, ((Number)value).doubleValue()), Collector.Type.GAUGE, help);
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
            if (!(value instanceof Number)) {
                LOGGER.fine("Ignoring non-Number bean: " + domain + beanProperties.toString() + attrKeys.toString() + attrName + ": " + value);
                return;
            }
            String beanName = domain + this.angleBrackets(beanProperties.toString()) + this.angleBrackets(attrKeys.toString());
            String help = attrDescription + " (" + beanName + attrName + ")";
            String attrNameSnakeCase = attrName.replaceAll("([a-z0-9])([A-Z])", "$1_$2").toLowerCase();
            for (Rule rule : JmxCollector.this.rules) {
                Matcher matcher = null;
                String matchName = beanName + (rule.attrNameSnakeCase ? attrNameSnakeCase : attrName);
                if (rule.pattern != null && !(matcher = rule.pattern.matcher(matchName + ": " + value)).matches()) continue;
                if (rule.name == null) {
                    this.defaultExport(domain, beanProperties, attrKeys, rule.attrNameSnakeCase ? attrNameSnakeCase : attrName, attrType, help, value);
                    return;
                }
                String name = this.safeName(matcher.replaceAll(rule.name));
                if (name.isEmpty()) {
                    return;
                }
                if (JmxCollector.this.lowercaseOutputName) {
                    name = name.toLowerCase();
                }
                if (rule.help != null) {
                    help = matcher.replaceAll(rule.help);
                }
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                if (rule.labelNames != null) {
                    for (int i = 0; i < rule.labelNames.size(); ++i) {
                        String labelName = this.safeName(matcher.replaceAll(rule.labelNames.get(i)));
                        String labelValue = matcher.replaceAll(rule.labelValues.get(i));
                        if (JmxCollector.this.lowercaseOutputLabelNames) {
                            labelName = labelName.toLowerCase();
                        }
                        if (labelName.isEmpty() || labelValue.isEmpty()) continue;
                        labelNames.add(labelName);
                        labelValues.add(labelValue);
                    }
                }
                LOGGER.fine("add metric sample: " + name + " " + labelNames + " " + labelValues + " " + ((Number)value).doubleValue());
                this.addSample(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, ((Number)value).doubleValue()), rule.type, help);
                return;
            }
        }
    }

    private static class Rule {
        Pattern pattern;
        String name;
        String help;
        boolean attrNameSnakeCase;
        Collector.Type type = Collector.Type.GAUGE;
        ArrayList<String> labelNames;
        ArrayList<String> labelValues;

        private Rule() {
        }
    }
}

