/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.DoubleAdder;
import io.prometheus.jmx.shaded.io.prometheus.client.GaugeMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.SimpleCollector;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class Gauge
extends SimpleCollector<Child>
implements Collector.Describable {
    Gauge(Builder b) {
        super(b);
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void inc() {
        this.inc(1.0);
    }

    public void inc(double amt) {
        ((Child)this.noLabelsChild).inc(amt);
    }

    public void dec() {
        this.dec(1.0);
    }

    public void dec(double amt) {
        ((Child)this.noLabelsChild).dec(amt);
    }

    public void set(double val) {
        ((Child)this.noLabelsChild).set(val);
    }

    public void setToCurrentTime() {
        ((Child)this.noLabelsChild).setToCurrentTime();
    }

    public Timer startTimer() {
        return ((Child)this.noLabelsChild).startTimer();
    }

    public double setToTime(Runnable timeable) {
        return ((Child)this.noLabelsChild).setToTime(timeable);
    }

    public <E> E setToTime(Callable<E> timeable) {
        return ((Child)this.noLabelsChild).setToTime(timeable);
    }

    public double get() {
        return ((Child)this.noLabelsChild).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(this.children.size());
        for (Map.Entry c : this.children.entrySet()) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, (List)c.getKey(), ((Child)c.getValue()).get()));
        }
        return this.familySamplesList(Collector.Type.GAUGE, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new GaugeMetricFamily(this.fullname, this.help, this.labelNames));
    }

    static class TimeProvider {
        TimeProvider() {
        }

        long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        long nanoTime() {
            return System.nanoTime();
        }
    }

    public static class Child {
        private final DoubleAdder value = new DoubleAdder();
        static TimeProvider timeProvider = new TimeProvider();

        public void inc() {
            this.inc(1.0);
        }

        public void inc(double amt) {
            this.value.add(amt);
        }

        public void dec() {
            this.dec(1.0);
        }

        public void dec(double amt) {
            this.value.add(-amt);
        }

        public void set(double val) {
            this.value.set(val);
        }

        public void setToCurrentTime() {
            this.set((double)timeProvider.currentTimeMillis() / 1000.0);
        }

        public Timer startTimer() {
            return new Timer(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double setToTime(Runnable timeable) {
            double elapsed;
            Timer timer = this.startTimer();
            try {
                timeable.run();
            }
            finally {
                elapsed = timer.setDuration();
            }
            return elapsed;
        }

        public <E> E setToTime(Callable<E> timeable) {
            Timer timer = this.startTimer();
            try {
                E e = timeable.call();
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                timer.setDuration();
            }
        }

        public double get() {
            return this.value.sum();
        }
    }

    public static class Timer
    implements Closeable {
        private final Child child;
        private final long start;

        private Timer(Child child) {
            this.child = child;
            this.start = Child.timeProvider.nanoTime();
        }

        public double setDuration() {
            double elapsed = (double)(Child.timeProvider.nanoTime() - this.start) / 1.0E9;
            this.child.set(elapsed);
            return elapsed;
        }

        @Override
        public void close() {
            this.setDuration();
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Gauge> {
        @Override
        public Gauge create() {
            return new Gauge(this);
        }
    }
}

