/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.yaml;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class YamlMapAccessor {
    private final Map<Object, Object> map;

    public YamlMapAccessor(Map<Object, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map is null");
        }
        this.map = map;
    }

    public boolean containsPath(String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("path [%s] is invalid", path));
        }
        if ((path = this.validatePath(path)).equals("/")) {
            return true;
        }
        String[] pathTokens = path.split(Pattern.quote("/"));
        Map subMap = this.map;
        for (int i = 1; i < pathTokens.length; ++i) {
            try {
                if (!subMap.containsKey(pathTokens[i])) {
                    return false;
                }
                subMap = (Map)subMap.get(pathTokens[i]);
                continue;
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    public Optional<Object> get(String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("path [%s] is invalid", path));
        }
        if ((path = this.validatePath(path)).equals("/")) {
            return Optional.of(this.map);
        }
        String[] pathTokens = path.split(Pattern.quote("/"));
        Map<Object, Object> object = this.map;
        for (int i = 1; i < pathTokens.length; ++i) {
            try {
                object = this.resolve(pathTokens[i], object);
                continue;
            }
            catch (NullPointerException e) {
                return Optional.ofNullable(null);
            }
            catch (ClassCastException e) {
                return Optional.ofNullable(null);
            }
        }
        return Optional.ofNullable(object);
    }

    public Optional<Object> getOrCreate(String path, Supplier<Object> supplier) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("path [%s] is invalid", path));
        }
        if ((path = this.validatePath(path)).equals("/")) {
            return Optional.of(this.map);
        }
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        String[] pathTokens = path.split(Pattern.quote("/"));
        Map<Object, Object> previous = this.map;
        LinkedHashMap current = null;
        for (int i = 1; i < pathTokens.length; ++i) {
            try {
                current = (LinkedHashMap)this.resolve(pathTokens[i], previous);
                if (current == null) {
                    if (i + 1 == pathTokens.length) {
                        Object object = supplier.get();
                        previous.put(pathTokens[i], object);
                        return Optional.of(object);
                    }
                    current = new LinkedHashMap();
                    previous.put(pathTokens[i], current);
                }
                previous = current;
                continue;
            }
            catch (NullPointerException e) {
                return Optional.ofNullable(null);
            }
            catch (ClassCastException e) {
                if (i + 1 == pathTokens.length) {
                    throw new IllegalArgumentException(String.format("path [%s] isn't a Map", this.flatten(pathTokens, 1, i)));
                }
                return Optional.ofNullable(null);
            }
        }
        return Optional.ofNullable(current);
    }

    public Optional<Object> getOrThrow(String path, Supplier<? extends RuntimeException> supplier) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("path [%s] is invalid", path));
        }
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if ((path = this.validatePath(path)).equals("/")) {
            return Optional.of(this.map);
        }
        String[] pathTokens = path.split(Pattern.quote("/"));
        Map<Object, Object> object = this.map;
        for (int i = 1; i < pathTokens.length; ++i) {
            try {
                object = this.resolve(pathTokens[i], object);
            }
            catch (NullPointerException e) {
                throw supplier.get();
            }
            catch (ClassCastException e) {
                throw supplier.get();
            }
            if (object != null || i >= pathTokens.length) continue;
            throw supplier.get();
        }
        return Optional.ofNullable(object);
    }

    public static YamlMapAccessor empty() {
        return new YamlMapAccessor(new LinkedHashMap<Object, Object>());
    }

    private String validatePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (path.equals("/")) {
            return path;
        }
        if ((path = path.trim()).isEmpty()) {
            throw new IllegalArgumentException("path is empty");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(String.format("path [%s] is invalid", path));
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException(String.format("path [%s] is invalid", path));
        }
        return path;
    }

    private <T> T resolve(String pathToken, Object object) {
        return (T)((Map)object).get(pathToken);
    }

    private String flatten(String[] pathTokens, int begin, int end) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = begin; i < end; ++i) {
            stringBuilder.append("/").append(pathTokens[i]);
        }
        return stringBuilder.toString();
    }
}

