/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.CounterMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.GaugeMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.Predicate;
import io.prometheus.jmx.shaded.io.prometheus.client.SampleNameFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadExports
extends Collector {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String JVM_THREADS_STATE = "jvm_threads_state";
    private static final String JVM_THREADS_CURRENT = "jvm_threads_current";
    private static final String JVM_THREADS_DAEMON = "jvm_threads_daemon";
    private static final String JVM_THREADS_PEAK = "jvm_threads_peak";
    private static final String JVM_THREADS_STARTED_TOTAL = "jvm_threads_started_total";
    private static final String JVM_THREADS_DEADLOCKED = "jvm_threads_deadlocked";
    private static final String JVM_THREADS_DEADLOCKED_MONITOR = "jvm_threads_deadlocked_monitor";
    private final ThreadMXBean threadBean;

    public ThreadExports() {
        this(ManagementFactory.getThreadMXBean());
    }

    public ThreadExports(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
    }

    void addThreadMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test(JVM_THREADS_CURRENT)) {
            sampleFamilies.add(new GaugeMetricFamily(JVM_THREADS_CURRENT, "Current thread count of a JVM", this.threadBean.getThreadCount()));
        }
        if (nameFilter.test(JVM_THREADS_DAEMON)) {
            sampleFamilies.add(new GaugeMetricFamily(JVM_THREADS_DAEMON, "Daemon thread count of a JVM", this.threadBean.getDaemonThreadCount()));
        }
        if (nameFilter.test(JVM_THREADS_PEAK)) {
            sampleFamilies.add(new GaugeMetricFamily(JVM_THREADS_PEAK, "Peak thread count of a JVM", this.threadBean.getPeakThreadCount()));
        }
        if (nameFilter.test(JVM_THREADS_STARTED_TOTAL)) {
            sampleFamilies.add(new CounterMetricFamily(JVM_THREADS_STARTED_TOTAL, "Started thread count of a JVM", this.threadBean.getTotalStartedThreadCount()));
        }
        if (nameFilter.test(JVM_THREADS_DEADLOCKED)) {
            sampleFamilies.add(new GaugeMetricFamily(JVM_THREADS_DEADLOCKED, "Cycles of JVM-threads that are in deadlock waiting to acquire object monitors or ownable synchronizers", ThreadExports.nullSafeArrayLength(this.threadBean.findDeadlockedThreads())));
        }
        if (nameFilter.test(JVM_THREADS_DEADLOCKED_MONITOR)) {
            sampleFamilies.add(new GaugeMetricFamily(JVM_THREADS_DEADLOCKED_MONITOR, "Cycles of JVM-threads that are in deadlock waiting to acquire object monitors", ThreadExports.nullSafeArrayLength(this.threadBean.findMonitorDeadlockedThreads())));
        }
        if (nameFilter.test(JVM_THREADS_STATE)) {
            GaugeMetricFamily threadStateFamily = new GaugeMetricFamily(JVM_THREADS_STATE, "Current count of threads by state", Collections.singletonList("state"));
            Map<String, Integer> threadStateCounts = this.getThreadStateCountMap();
            for (Map.Entry<String, Integer> entry : threadStateCounts.entrySet()) {
                threadStateFamily.addMetric(Collections.singletonList(entry.getKey()), entry.getValue().intValue());
            }
            sampleFamilies.add(threadStateFamily);
        }
    }

    private Map<String, Integer> getThreadStateCountMap() {
        long[] threadIds = this.threadBean.getAllThreadIds();
        int writePos = 0;
        for (int i = 0; i < threadIds.length; ++i) {
            if (threadIds[i] <= 0L) continue;
            threadIds[writePos++] = threadIds[i];
        }
        int numberOfInvalidThreadIds = threadIds.length - writePos;
        threadIds = Arrays.copyOf(threadIds, writePos);
        ThreadInfo[] allThreads = this.threadBean.getThreadInfo(threadIds, 0);
        HashMap<String, Integer> threadCounts = new HashMap<String, Integer>();
        for (Thread.State state : Thread.State.values()) {
            threadCounts.put(state.name(), 0);
        }
        for (ThreadInfo threadInfo : allThreads) {
            if (threadInfo == null) continue;
            Thread.State threadState = threadInfo.getThreadState();
            threadCounts.put(threadState.name(), threadCounts.get(threadState.name()) + 1);
        }
        threadCounts.put(UNKNOWN, numberOfInvalidThreadIds);
        return threadCounts;
    }

    private static double nullSafeArrayLength(long[] array) {
        return null == array ? 0.0 : (double)array.length;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addThreadMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        return mfs;
    }
}

