/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.jmx;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.Counter;
import io.prometheus.jmx.shaded.io.prometheus.jmx.JmxScraper;
import io.prometheus.jmx.shaded.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxCollector
extends Collector
implements Collector.Describable {
    static final Counter configReloadSuccess = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("jmx_config_reload_success_total")).help("Number of times configuration have successfully been reloaded.")).register();
    static final Counter configReloadFailure = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("jmx_config_reload_failure_total")).help("Number of times configuration have failed to be reloaded.")).register();
    private static final Logger LOGGER = Logger.getLogger(JmxCollector.class.getName());
    private Config config;
    private File configFile;
    private long createTimeNanoSecs = System.nanoTime();
    private static final Pattern snakeCasePattern = Pattern.compile("([a-z0-9])([A-Z])");

    public JmxCollector(File in) throws IOException, MalformedObjectNameException {
        this.configFile = in;
        this.config = this.loadConfig((Map)new Yaml().load(new FileReader(in)));
        this.config.lastUpdate = this.configFile.lastModified();
    }

    public JmxCollector(String yamlConfig) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(yamlConfig));
    }

    private void reloadConfig() {
        try {
            FileReader fr = new FileReader(this.configFile);
            try {
                Map newYamlConfig = (Map)new Yaml().load(fr);
                this.config = this.loadConfig(newYamlConfig);
                this.config.lastUpdate = this.configFile.lastModified();
                configReloadSuccess.inc();
            }
            catch (Exception e) {
                LOGGER.severe("Configuration reload failed: " + e.toString());
                configReloadFailure.inc();
            }
            finally {
                fr.close();
            }
        }
        catch (IOException e) {
            LOGGER.severe("Configuration reload failed: " + e.toString());
            configReloadFailure.inc();
        }
    }

    private Config loadConfig(Map<String, Object> yamlConfig) throws MalformedObjectNameException {
        List names;
        Config cfg = new Config();
        if (yamlConfig == null) {
            yamlConfig = new HashMap<String, Object>();
        }
        if (yamlConfig.containsKey("startDelaySeconds")) {
            try {
                cfg.startDelaySeconds = (Integer)yamlConfig.get("startDelaySeconds");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number provided for startDelaySeconds", e);
            }
        }
        if (yamlConfig.containsKey("hostPort")) {
            if (yamlConfig.containsKey("jmxUrl")) {
                throw new IllegalArgumentException("At most one of hostPort and jmxUrl must be provided");
            }
            cfg.jmxUrl = "service:jmx:rmi:///jndi/rmi://" + (String)yamlConfig.get("hostPort") + "/jmxrmi";
        } else if (yamlConfig.containsKey("jmxUrl")) {
            cfg.jmxUrl = (String)yamlConfig.get("jmxUrl");
        }
        if (yamlConfig.containsKey("username")) {
            cfg.username = (String)yamlConfig.get("username");
        }
        if (yamlConfig.containsKey("password")) {
            cfg.password = (String)yamlConfig.get("password");
        }
        if (yamlConfig.containsKey("ssl")) {
            cfg.ssl = (Boolean)yamlConfig.get("ssl");
        }
        if (yamlConfig.containsKey("lowercaseOutputName")) {
            cfg.lowercaseOutputName = (Boolean)yamlConfig.get("lowercaseOutputName");
        }
        if (yamlConfig.containsKey("lowercaseOutputLabelNames")) {
            cfg.lowercaseOutputLabelNames = (Boolean)yamlConfig.get("lowercaseOutputLabelNames");
        }
        if (yamlConfig.containsKey("whitelistObjectNames")) {
            names = (List)yamlConfig.get("whitelistObjectNames");
            for (Object name : names) {
                cfg.whitelistObjectNames.add(new ObjectName((String)name));
            }
        } else {
            cfg.whitelistObjectNames.add(null);
        }
        if (yamlConfig.containsKey("blacklistObjectNames")) {
            names = (List)yamlConfig.get("blacklistObjectNames");
            for (Object name : names) {
                cfg.blacklistObjectNames.add(new ObjectName((String)name));
            }
        }
        if (yamlConfig.containsKey("rules")) {
            List configRules = (List)yamlConfig.get("rules");
            Iterator iterator = configRules.iterator();
            while (iterator.hasNext()) {
                Map ruleObject;
                Map yamlRule = ruleObject = (Map)iterator.next();
                Rule rule = new Rule();
                cfg.rules.add(rule);
                if (yamlRule.containsKey("pattern")) {
                    rule.pattern = Pattern.compile("^.*" + (String)yamlRule.get("pattern") + ".*$");
                }
                if (yamlRule.containsKey("name")) {
                    rule.name = (String)yamlRule.get("name");
                }
                if (yamlRule.containsKey("value")) {
                    rule.value = String.valueOf(yamlRule.get("value"));
                }
                if (yamlRule.containsKey("valueFactor")) {
                    String valueFactor = String.valueOf(yamlRule.get("valueFactor"));
                    try {
                        rule.valueFactor = Double.valueOf(valueFactor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (yamlRule.containsKey("attrNameSnakeCase")) {
                    rule.attrNameSnakeCase = (Boolean)yamlRule.get("attrNameSnakeCase");
                }
                if (yamlRule.containsKey("type")) {
                    rule.type = Collector.Type.valueOf((String)yamlRule.get("type"));
                }
                if (yamlRule.containsKey("help")) {
                    rule.help = (String)yamlRule.get("help");
                }
                if (yamlRule.containsKey("labels")) {
                    TreeMap labels = new TreeMap((Map)yamlRule.get("labels"));
                    rule.labelNames = new ArrayList();
                    rule.labelValues = new ArrayList();
                    for (Map.Entry entry : labels.entrySet()) {
                        rule.labelNames.add((String)entry.getKey());
                        rule.labelValues.add((String)entry.getValue());
                    }
                }
                if ((rule.labelNames != null || rule.help != null) && rule.name == null) {
                    throw new IllegalArgumentException("Must provide name, if help or labels are given: " + yamlRule);
                }
                if (rule.name == null || rule.pattern != null) continue;
                throw new IllegalArgumentException("Must provide pattern, if name is given: " + yamlRule);
            }
        } else {
            cfg.rules.add(new Rule());
        }
        return cfg;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        long mtime;
        if (this.configFile != null && (mtime = this.configFile.lastModified()) > this.config.lastUpdate) {
            LOGGER.fine("Configuration file changed, reloading...");
            this.reloadConfig();
        }
        Receiver receiver = new Receiver();
        JmxScraper scraper = new JmxScraper(this.config.jmxUrl, this.config.username, this.config.password, this.config.ssl, this.config.whitelistObjectNames, this.config.blacklistObjectNames, receiver);
        long start = System.nanoTime();
        double error = 0.0;
        if (this.config.startDelaySeconds > 0 && (start - this.createTimeNanoSecs) / 1000000000L < (long)this.config.startDelaySeconds.intValue()) {
            throw new IllegalStateException("JMXCollector waiting for startDelaySeconds");
        }
        try {
            scraper.doScrape();
        }
        catch (Exception e) {
            error = 1.0;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.severe("JMX scrape failed: " + sw.toString());
        }
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.addAll(receiver.metricFamilySamplesMap.values());
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_duration_seconds", new ArrayList<String>(), new ArrayList<String>(), (double)(System.nanoTime() - start) / 1.0E9));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", samples));
        samples = new ArrayList();
        samples.add(new Collector.MetricFamilySamples.Sample("jmx_scrape_error", new ArrayList<String>(), new ArrayList<String>(), error));
        mfsList.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", samples));
        return mfsList;
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> sampleFamilies = new ArrayList<Collector.MetricFamilySamples>();
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_duration_seconds", Collector.Type.GAUGE, "Time this JMX scrape took, in seconds.", new ArrayList<Collector.MetricFamilySamples.Sample>()));
        sampleFamilies.add(new Collector.MetricFamilySamples("jmx_scrape_error", Collector.Type.GAUGE, "Non-zero if this scrape failed.", new ArrayList<Collector.MetricFamilySamples.Sample>()));
        return sampleFamilies;
    }

    public static void main(String[] args) throws Exception {
        String hostPort = "";
        if (args.length > 0) {
            hostPort = args[0];
        }
        JmxCollector jc = new JmxCollector(("{`hostPort`: `" + hostPort + "`,}").replace('`', '\"'));
        for (Collector.MetricFamilySamples mfs : jc.collect()) {
            System.out.println(mfs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Receiver
    implements JmxScraper.MBeanReceiver {
        Map<String, Collector.MetricFamilySamples> metricFamilySamplesMap = new HashMap<String, Collector.MetricFamilySamples>();
        private static final char SEP = '_';
        private final Pattern unsafeChars = Pattern.compile("[^a-zA-Z0-9:_]");
        private final Pattern multipleUnderscores = Pattern.compile("__+");

        Receiver() {
        }

        private String angleBrackets(String s) {
            return "<" + s.substring(1, s.length() - 1) + ">";
        }

        private String safeName(String s) {
            return this.multipleUnderscores.matcher(this.unsafeChars.matcher(s).replaceAll("_")).replaceAll("_");
        }

        void addSample(Collector.MetricFamilySamples.Sample sample, Collector.Type type, String help) {
            Collector.MetricFamilySamples mfs = this.metricFamilySamplesMap.get(sample.name);
            if (mfs == null) {
                mfs = new Collector.MetricFamilySamples(sample.name, type, help, new ArrayList<Collector.MetricFamilySamples.Sample>());
                this.metricFamilySamplesMap.put(sample.name, mfs);
            }
            mfs.samples.add(sample);
        }

        private void defaultExport(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String help, Object value, Collector.Type type) {
            StringBuilder name = new StringBuilder();
            name.append(domain);
            if (beanProperties.size() > 0) {
                name.append('_');
                name.append(beanProperties.values().iterator().next());
            }
            for (String k : attrKeys) {
                name.append('_');
                name.append(k);
            }
            name.append('_');
            name.append(attrName);
            String fullname = this.safeName(name.toString());
            if (((JmxCollector)JmxCollector.this).config.lowercaseOutputName) {
                fullname = fullname.toLowerCase();
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            ArrayList<String> labelValues = new ArrayList<String>();
            if (beanProperties.size() > 1) {
                Iterator<Map.Entry<String, String>> iter = beanProperties.entrySet().iterator();
                iter.next();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String labelName = this.safeName(entry.getKey());
                    if (((JmxCollector)JmxCollector.this).config.lowercaseOutputLabelNames) {
                        labelName = labelName.toLowerCase();
                    }
                    labelNames.add(labelName);
                    labelValues.add(entry.getValue());
                }
            }
            this.addSample(new Collector.MetricFamilySamples.Sample(fullname, labelNames, labelValues, ((Number)value).doubleValue()), type, help);
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object beanValue) {
            String beanName = domain + this.angleBrackets(beanProperties.toString()) + this.angleBrackets(attrKeys.toString());
            String help = attrDescription + " (" + beanName + attrName + ")";
            String attrNameSnakeCase = snakeCasePattern.matcher(attrName).replaceAll("$1_$2").toLowerCase();
            for (Rule rule : ((JmxCollector)JmxCollector.this).config.rules) {
                Number value;
                Matcher matcher = null;
                String matchName = beanName + (rule.attrNameSnakeCase ? attrNameSnakeCase : attrName);
                if (rule.pattern != null && !(matcher = rule.pattern.matcher(matchName + ": " + beanValue)).matches()) continue;
                if (rule.value != null && !rule.value.isEmpty()) {
                    String val = matcher.replaceAll(rule.value);
                    try {
                        beanValue = Double.valueOf(val);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.fine("Unable to parse configured value '" + val + "' to number for bean: " + beanName + attrName + ": " + beanValue);
                        return;
                    }
                }
                if (beanValue instanceof Number) {
                    value = ((Number)beanValue).doubleValue() * rule.valueFactor;
                } else if (beanValue instanceof Boolean) {
                    value = (Boolean)beanValue != false ? 1 : 0;
                } else {
                    LOGGER.fine("Ignoring unsupported bean: " + beanName + attrName + ": " + beanValue);
                    return;
                }
                if (rule.name == null) {
                    this.defaultExport(domain, beanProperties, attrKeys, rule.attrNameSnakeCase ? attrNameSnakeCase : attrName, attrType, help, value, rule.type);
                    return;
                }
                String name = this.safeName(matcher.replaceAll(rule.name));
                if (name.isEmpty()) {
                    return;
                }
                if (((JmxCollector)JmxCollector.this).config.lowercaseOutputName) {
                    name = name.toLowerCase();
                }
                if (rule.help != null) {
                    help = matcher.replaceAll(rule.help);
                }
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                if (rule.labelNames != null) {
                    for (int i = 0; i < rule.labelNames.size(); ++i) {
                        String unsafeLabelName = rule.labelNames.get(i);
                        String labelValReplacement = rule.labelValues.get(i);
                        try {
                            String labelName = this.safeName(matcher.replaceAll(unsafeLabelName));
                            String labelValue = matcher.replaceAll(labelValReplacement);
                            if (((JmxCollector)JmxCollector.this).config.lowercaseOutputLabelNames) {
                                labelName = labelName.toLowerCase();
                            }
                            if (labelName.isEmpty() || labelValue.isEmpty()) continue;
                            labelNames.add(labelName);
                            labelValues.add(labelValue);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Matcher '%s' unable to use: '%s' value: '%s'", matcher, unsafeLabelName, labelValReplacement), e);
                        }
                    }
                }
                LOGGER.fine("add metric sample: " + name + " " + labelNames + " " + labelValues + " " + value.doubleValue());
                this.addSample(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value.doubleValue()), rule.type, help);
                return;
            }
        }
    }

    private static class Config {
        Integer startDelaySeconds = 0;
        String jmxUrl = "";
        String username = "";
        String password = "";
        boolean ssl = false;
        boolean lowercaseOutputName;
        boolean lowercaseOutputLabelNames;
        List<ObjectName> whitelistObjectNames = new ArrayList<ObjectName>();
        List<ObjectName> blacklistObjectNames = new ArrayList<ObjectName>();
        ArrayList<Rule> rules = new ArrayList();
        long lastUpdate = 0L;

        private Config() {
        }
    }

    private static class Rule {
        Pattern pattern;
        String name;
        String value;
        Double valueFactor = 1.0;
        String help;
        boolean attrNameSnakeCase;
        Collector.Type type = Collector.Type.UNTYPED;
        ArrayList<String> labelNames;
        ArrayList<String> labelValues;

        private Rule() {
        }
    }
}

