/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client.exporter;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.prometheus.jmx.shaded.io.prometheus.client.CollectorRegistry;
import io.prometheus.jmx.shaded.io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;

public class HTTPServer {
    protected HttpServer server = HttpServer.create();

    protected static Set<String> parseQuery(String query) throws IOException {
        HashSet<String> names = new HashSet<String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1 || !URLDecoder.decode(pair.substring(0, idx), "UTF-8").equals("name[]")) continue;
                names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        return names;
    }

    public HTTPServer(InetSocketAddress addr, CollectorRegistry registry) throws IOException {
        this.server.bind(addr, 3);
        HTTPMetricHandler mHandler = new HTTPMetricHandler(registry);
        this.server.createContext("/", mHandler);
        this.server.createContext("/metrics", mHandler);
        this.server.setExecutor(Executors.newFixedThreadPool(5));
        this.server.start();
    }

    public HTTPServer(int port) throws IOException {
        this(new InetSocketAddress(port), CollectorRegistry.defaultRegistry);
    }

    public HTTPServer(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port), CollectorRegistry.defaultRegistry);
    }

    public void stop() {
        this.server.stop(0);
    }

    static class HTTPMetricHandler
    implements HttpHandler {
        private CollectorRegistry registry;

        HTTPMetricHandler(CollectorRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String query = t.getRequestURI().getRawQuery();
            ByteArrayOutputStream response = new ByteArrayOutputStream(0x100000);
            OutputStreamWriter osw = new OutputStreamWriter(response);
            TextFormat.write004(osw, this.registry.filteredMetricFamilySamples(HTTPServer.parseQuery(query)));
            osw.flush();
            osw.close();
            response.flush();
            response.close();
            t.getResponseHeaders().set("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
            t.getResponseHeaders().set("Content-Length", String.valueOf(response.size()));
            t.sendResponseHeaders(200, response.size());
            response.writeTo(t.getResponseBody());
            t.close();
        }
    }
}

