/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.shaded.net.bytebuddy.matcher;

import java.util.Set;
import reactor.tools.shaded.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import reactor.tools.shaded.net.bytebuddy.matcher.ElementMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class StringSetMatcher
extends ElementMatcher.Junction.AbstractBase<String> {
    private final Set<String> values;

    public StringSetMatcher(Set<String> values) {
        this.values = values;
    }

    @Override
    public boolean matches(String target) {
        return this.values.contains(target);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("in(");
        boolean first = true;
        for (String value : this.values) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(value);
        }
        return stringBuilder.append(")").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return ((Object)this.values).equals(((StringSetMatcher)object).values);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + ((Object)this.values).hashCode();
    }
}

