/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.Exceptions;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.action.CompositeAction;

public class LiftStream<O, V>
extends Stream<V> {
    private final Stream<O> producer;
    private final Supplier<? extends Action<O, V>> child;

    public LiftStream(Stream<O> thiz, Supplier<? extends Action<O, V>> action) {
        this.producer = thiz;
        this.child = action;
    }

    public final Action<O, V> onLift() {
        return (Action)this.child.get();
    }

    @Override
    public final <E> CompositeAction<E, V> combine() {
        Action<O, V> action = this.onLift();
        if (action == null) {
            throw new IllegalStateException("Cannot combine streams without any lifted action");
        }
        this.producer.subscribe((Subscriber)action);
        return action.combine();
    }

    @Override
    public long getCapacity() {
        return this.producer.getCapacity();
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.producer.getDispatcher();
    }

    @Override
    public Environment getEnvironment() {
        return this.producer.getEnvironment();
    }

    public final void subscribe(Subscriber<? super V> s) {
        try {
            Action<? super V, V> action = this.onLift();
            action.subscribe(s);
            this.producer.subscribe((Subscriber)action);
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal((Throwable)throwable);
            s.onError(throwable);
        }
    }

    @Override
    public final String toString() {
        return "LiftStream{producer=" + this.producer.getClass().getSimpleName() + '}';
    }
}

