/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.Connection;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class WebsocketServerOperations
extends HttpServerOperations
implements WebsocketInbound,
WebsocketOutbound {
    WebSocketServerHandshaker handshakerHttp11;
    ChannelPromise handshakerResult;
    final Sinks.One<WebSocketCloseStatus> onCloseState;
    final boolean proxyPing;
    volatile int closeSent;
    static final String INBOUND_CANCEL_LOG = "WebSocket server inbound receiver cancelled, closing Websocket.";
    static final AtomicIntegerFieldUpdater<WebsocketServerOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketServerOperations.class, "closeSent");

    WebsocketServerOperations(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        super(replaced);
        this.proxyPing = websocketServerSpec.handlePing();
        this.onCloseState = Sinks.unsafe().one();
        this.initHandshaker(wsUrl, websocketServerSpec, replaced);
    }

    void initHandshaker(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        Channel channel = replaced.channel();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, websocketServerSpec.protocols(), true, websocketServerSpec.maxFramePayloadLength());
        this.handshakerHttp11 = wsFactory.newHandshaker(replaced.nettyRequest);
        if (this.handshakerHttp11 == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
            this.handshakerResult = null;
        } else {
            this.removeHandler("reactor.left.httpTrafficHandler");
            this.removeHandler("reactor.left.accessLogHandler");
            ChannelHandler handler = channel.pipeline().get("reactor.left.httpMetricsHandler");
            if (handler != null) {
                this.replaceHandler("reactor.left.httpMetricsHandler", (ChannelHandler)new WebsocketHttpServerMetricsHandler((AbstractHttpServerMetricsHandler)handler));
            }
            this.handshakerResult = channel.newPromise();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (websocketServerSpec.compress()) {
                this.removeHandler("reactor.left.compressionHandler");
                PerMessageDeflateServerExtensionHandshaker perMessageDeflateServerExtensionHandshaker = new PerMessageDeflateServerExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketServerSpec.compressionAllowServerNoContext(), websocketServerSpec.compressionPreferredClientNoContext());
                WebSocketServerExtensionHandler wsServerExtensionHandler = new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{perMessageDeflateServerExtensionHandshaker, new DeflateFrameServerExtensionHandshaker()});
                try {
                    ChannelPipeline pipeline = channel.pipeline();
                    wsServerExtensionHandler.channelRead(pipeline.context("reactor.right.reactiveBridge"), (Object)request);
                    String baseName = null;
                    if (pipeline.get("reactor.left.httpCodec") != null) {
                        baseName = "reactor.left.httpCodec";
                    } else {
                        ChannelHandler httpServerCodec = pipeline.get(HttpServerCodec.class);
                        if (httpServerCodec != null) {
                            baseName = pipeline.context(httpServerCodec).name();
                        }
                    }
                    pipeline.addAfter(baseName, "reactor.left.wsCompressionHandler", (ChannelHandler)wsServerExtensionHandler);
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format((Channel)this.channel(), (String)""), e);
                }
            }
            this.handshakerHttp11.handshake(channel, (HttpRequest)request, replaced.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener(f -> {
                if (replaced.rebind((Connection)this)) {
                    this.markPersistent(false);
                    channel.read();
                } else if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)channel, (String)"Cannot bind WebsocketServerOperations after the handshake."));
                }
            });
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject((Publisher)Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public HttpHeaders headers() {
        return this.requestHeaders();
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object frame) {
        if (frame instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)frame).isFinalFragment()) {
            CloseWebSocketFrame closeFrame;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.channel(), (String)"CloseWebSocketFrame detected. Closing Websocket"));
            }
            if ((closeFrame = new CloseWebSocketFrame(true, ((CloseWebSocketFrame)frame).rsv(), ((CloseWebSocketFrame)frame).content())).statusCode() != -1) {
                this.sendCloseNow(closeFrame, f -> this.terminate());
            } else {
                this.sendCloseNow(closeFrame, WebSocketCloseStatus.EMPTY, f -> this.terminate());
            }
            return;
        }
        if (!this.proxyPing && frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)frame).content()));
            ctx.read();
            return;
        }
        if (frame != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, frame);
        }
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.channel(), (String)"Outbound error happened"), err);
            }
            this.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.PROTOCOL_ERROR), f -> this.terminate());
        }
    }

    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)this.channel(), (String)INBOUND_CANCEL_LOG));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE, f -> this.terminate());
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.asMono().or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue((Object)new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease((Object)frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(CloseWebSocketFrame frame, ChannelFutureListener listener) {
        this.sendCloseNow(frame, new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()), listener);
    }

    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus, ChannelFutureListener listener) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush((Object)frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue((Object)closeStatus);
            this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)listener);
        } else {
            frame.release();
        }
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public @Nullable String selectedSubprotocol() {
        return this.handshakerHttp11.selectedSubprotocol();
    }

    Subscriber<Void> websocketSubscriber(ContextView contextView) {
        return new HttpServerOperations.WebsocketSubscriber(this, Context.of((ContextView)contextView));
    }

    static final class WebsocketHttpServerMetricsHandler
    extends AbstractHttpServerMetricsHandler {
        final HttpServerMetricsRecorder recorder;

        WebsocketHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
            super(copy);
            this.recorder = copy.recorder();
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            try {
                if (this.channelOpened && this.recorder instanceof MicrometerHttpServerMetricsRecorder) {
                    this.channelOpened = false;
                    this.recorder.recordServerConnectionClosed(ctx.channel().localAddress());
                }
                if (this.channelActivated) {
                    this.channelActivated = false;
                    this.recorder.recordServerConnectionInactive(ctx.channel().localAddress());
                }
            }
            catch (RuntimeException e) {
                if (HttpServerOperations.log.isWarnEnabled()) {
                    HttpServerOperations.log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                }
            }
            finally {
                ctx.fireChannelInactive();
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise);
        }

        @Override
        public HttpServerMetricsRecorder recorder() {
            return this.recorder;
        }
    }
}

