/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AsciiString;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbstractChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.Http2SettingsSpec;
import reactor.netty.http.Http3SettingsSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.HttpResources;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.logging.ReactorNettyHttpMessageLogFactory;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.ContextAwareHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.HAProxyMessageDetector;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.Http2StreamBridgeServerHandler;
import reactor.netty.http.server.Http3ChannelInitializer;
import reactor.netty.http.server.Http3Codec;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpTrafficHandler;
import reactor.netty.http.server.IdleTimeoutHandler;
import reactor.netty.http.server.MicrometerHttpServerMetricsHandler;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.http.server.NonSslRedirectDetector;
import reactor.netty.http.server.ProxyProtocolSupportType;
import reactor.netty.http.server.RequestTimeoutException;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogHandlerFactory;
import reactor.netty.http.server.logging.error.DefaultErrorLogHandler;
import reactor.netty.http.server.logging.error.ErrorLog;
import reactor.netty.http.server.logging.error.ErrorLogArgProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ServerTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Incubating;

public final class HttpServerConfig
extends ServerTransportConfig<HttpServerConfig> {
    boolean accessLogEnabled;
    @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;
    @Nullable HttpCompressionOptionsSpec compressionOptions;
    @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
    ServerCookieDecoder cookieDecoder;
    ServerCookieEncoder cookieEncoder;
    HttpRequestDecoderSpec decoder;
    boolean errorLogEnabled;
    @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog;
    HttpServerFormDecoderProvider formDecoderProvider;
    @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    @Nullable Http2SettingsSpec http2Settings;
    @Nullable Http3SettingsSpec http3Settings;
    HttpMessageLogFactory httpMessageLogFactory;
    @Nullable Duration idleTimeout;
    @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    int maxKeepAliveRequests;
    @Nullable Function<String, String> methodTagValue;
    int minCompressionSize;
    HttpProtocol[] protocols;
    int _protocols;
    ProxyProtocolSupportType proxyProtocolSupportType;
    @Nullable Duration readTimeout;
    boolean redirectHttpToHttps;
    @Nullable Duration requestTimeout;
    @Nullable SslProvider sslProvider;
    @Nullable Function<String, String> uriTagValue;
    static final boolean ACCESS_LOG = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.accessLogEnabled", "false"));
    static final int h3 = 8;
    static final int h2 = 2;
    static final int h2c = 1;
    static final int h11 = 4;
    static final int h11orH2 = 6;
    static final int h11orH2C = 5;
    static final Http2StreamFrameToHttpObjectCodec HTTP2_STREAM_FRAME_TO_HTTP_OBJECT = new Http2StreamFrameToHttpObjectCodec(true);
    static final Logger log = Loggers.getLogger(HttpServerConfig.class);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(HttpServer.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());
    static final boolean SSL_DEBUG = Boolean.parseBoolean(System.getProperty("reactor.netty.tcp.ssl.server.debug", "false"));
    static final char SETTINGS_ENABLE_CONNECT_PROTOCOL = '\b';
    static final Long FALSE = 0L;
    static final Long TRUE = 1L;

    public @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate() {
        return this.compressPredicate;
    }

    @Deprecated
    public ServerCookieDecoder cookieDecoder() {
        return this.cookieDecoder;
    }

    @Deprecated
    public ServerCookieEncoder cookieEncoder() {
        return this.cookieEncoder;
    }

    public HttpRequestDecoderSpec decoder() {
        return this.decoder;
    }

    public HttpServerFormDecoderProvider formDecoderProvider() {
        return this.formDecoderProvider;
    }

    public @Nullable Http2SettingsSpec http2SettingsSpec() {
        return this.http2Settings;
    }

    @Incubating
    public @Nullable Http3SettingsSpec http3SettingsSpec() {
        return this.http3Settings;
    }

    public @Nullable Duration idleTimeout() {
        return this.idleTimeout;
    }

    public boolean isForwarded() {
        return this.forwardedHeaderHandler != null;
    }

    public boolean isSecure() {
        return this.sslProvider != null;
    }

    public int maxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public int minCompressionSize() {
        return this.minCompressionSize;
    }

    public HttpProtocol[] protocols() {
        return this.protocols;
    }

    public ProxyProtocolSupportType proxyProtocolSupportType() {
        return this.proxyProtocolSupportType;
    }

    public @Nullable Duration readTimeout() {
        return this.readTimeout;
    }

    public boolean redirectHttpToHttps() {
        return this.redirectHttpToHttps;
    }

    public @Nullable Duration requestTimeout() {
        return this.requestTimeout;
    }

    public @Nullable SslProvider sslProvider() {
        return this.sslProvider;
    }

    public @Nullable Function<String, String> uriTagValue() {
        return this.uriTagValue;
    }

    HttpServerConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> childOptions, Supplier<? extends SocketAddress> localAddress) {
        super(options, childOptions, localAddress);
        this.cookieDecoder = ServerCookieDecoder.STRICT;
        this.cookieEncoder = ServerCookieEncoder.STRICT;
        this.decoder = new HttpRequestDecoderSpec();
        this.formDecoderProvider = HttpServerFormDecoderProvider.DEFAULT_FORM_DECODER_SPEC;
        this.httpMessageLogFactory = ReactorNettyHttpMessageLogFactory.INSTANCE;
        this.maxKeepAliveRequests = -1;
        this.minCompressionSize = -1;
        this.protocols = new HttpProtocol[]{HttpProtocol.HTTP11};
        this._protocols = 4;
        this.proxyProtocolSupportType = ProxyProtocolSupportType.OFF;
        this.accessLogEnabled = ACCESS_LOG;
    }

    HttpServerConfig(HttpServerConfig parent) {
        super((ServerTransportConfig)parent);
        this.accessLogEnabled = parent.accessLogEnabled;
        this.accessLog = parent.accessLog;
        this.compressionOptions = parent.compressionOptions;
        this.compressPredicate = parent.compressPredicate;
        this.cookieDecoder = parent.cookieDecoder;
        this.cookieEncoder = parent.cookieEncoder;
        this.decoder = parent.decoder;
        this.errorLogEnabled = parent.errorLogEnabled;
        this.errorLog = parent.errorLog;
        this.formDecoderProvider = parent.formDecoderProvider;
        this.forwardedHeaderHandler = parent.forwardedHeaderHandler;
        this.http2Settings = parent.http2Settings;
        this.http3Settings = parent.http3Settings;
        this.httpMessageLogFactory = parent.httpMessageLogFactory;
        this.idleTimeout = parent.idleTimeout;
        this.mapHandle = parent.mapHandle;
        this.maxKeepAliveRequests = parent.maxKeepAliveRequests;
        this.methodTagValue = parent.methodTagValue;
        this.minCompressionSize = parent.minCompressionSize;
        this.protocols = parent.protocols;
        this._protocols = parent._protocols;
        this.proxyProtocolSupportType = parent.proxyProtocolSupportType;
        this.readTimeout = parent.readTimeout;
        this.redirectHttpToHttps = parent.redirectHttpToHttps;
        this.requestTimeout = parent.requestTimeout;
        this.sslProvider = parent.sslProvider;
        this.uriTagValue = parent.uriTagValue;
    }

    public ChannelInitializer<Channel> channelInitializer(ConnectionObserver connectionObserver, @Nullable SocketAddress remoteAddress, boolean onServer) {
        ChannelInitializer channelInitializer = super.channelInitializer(connectionObserver, remoteAddress, onServer);
        return (this._protocols & 8) == 8 ? new Http3ChannelInitializer(this, (ChannelInitializer<Channel>)channelInitializer) : channelInitializer;
    }

    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? ServerDomainSocketChannel.class : ((this._protocols & 8) == 8 ? DatagramChannel.class : ServerSocketChannel.class);
    }

    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    protected LoopResources defaultLoopResources() {
        return HttpResources.get();
    }

    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerHttpServerMetricsRecorder.INSTANCE;
    }

    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        return super.defaultOnChannelInit().then((ChannelPipelineConfigurer)new HttpServerChannelInitializer(this));
    }

    protected void loggingHandler(LoggingHandler loggingHandler) {
        super.loggingHandler(loggingHandler);
    }

    protected void metricsRecorder(@Nullable Supplier<? extends ChannelMetricsRecorder> metricsRecorder) {
        super.metricsRecorder(metricsRecorder);
    }

    void protocols(HttpProtocol ... protocols) {
        this.protocols = protocols;
        int _protocols = 0;
        for (HttpProtocol p : protocols) {
            if (p == HttpProtocol.HTTP11) {
                _protocols |= 4;
                continue;
            }
            if (p == HttpProtocol.H2) {
                _protocols |= 2;
                continue;
            }
            if (p == HttpProtocol.H2C) {
                _protocols |= 1;
                continue;
            }
            if (p != HttpProtocol.HTTP3) continue;
            _protocols |= 8;
        }
        this._protocols = _protocols;
    }

    static Http2Settings http2Settings(@Nullable Http2SettingsSpec http2Settings) {
        Http2Settings settings = Http2Settings.defaultSettings();
        if (http2Settings != null) {
            Integer maxFrameSize;
            Long maxConcurrentStreams;
            Integer initialWindowSize;
            Long headerTableSize;
            Boolean connectProtocolEnabled = http2Settings.connectProtocolEnabled();
            if (connectProtocolEnabled != null) {
                settings.put('\b', connectProtocolEnabled != false ? TRUE : FALSE);
            }
            if ((headerTableSize = http2Settings.headerTableSize()) != null) {
                settings.headerTableSize(headerTableSize.longValue());
            }
            if ((initialWindowSize = http2Settings.initialWindowSize()) != null) {
                settings.initialWindowSize(initialWindowSize.intValue());
            }
            if ((maxConcurrentStreams = http2Settings.maxConcurrentStreams()) != null) {
                settings.maxConcurrentStreams(maxConcurrentStreams.longValue());
            }
            if ((maxFrameSize = http2Settings.maxFrameSize()) != null) {
                settings.maxFrameSize(maxFrameSize.intValue());
            }
            settings.maxHeaderListSize(http2Settings.maxHeaderListSize().longValue());
            Boolean pushEnabled = http2Settings.pushEnabled();
            if (pushEnabled != null) {
                settings.pushEnabled(pushEnabled.booleanValue());
            }
        }
        return settings;
    }

    static void addStreamHandlers(Channel ch, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable Boolean connectProtocolEnabled, ServerCookieDecoder decoder, ServerCookieEncoder encoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue) {
        boolean alwaysCompress;
        ChannelPipeline pipeline = ch.pipeline();
        if (accessLogEnabled) {
            pipeline.addLast("reactor.left.accessLogHandler", AccessLogHandlerFactory.H2.create(accessLog));
        }
        if (Boolean.TRUE.equals(connectProtocolEnabled)) {
            pipeline.addLast("reactor.left.protocolHeaderHandler", (ChannelHandler)ProtocolHeaderHandler.INSTANCE);
        }
        pipeline.addLast("reactor.left.h2ToHttp11Codec", (ChannelHandler)HTTP2_STREAM_FRAME_TO_HTTP_OBJECT).addLast("reactor.left.httpTrafficHandler", (ChannelHandler)new Http2StreamBridgeServerHandler(compressPredicate, compressionOptions, decoder, encoder, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, listener, mapHandle, readTimeout, requestTimeout));
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            pipeline.addLast("reactor.left.compressionHandler", (ChannelHandler)SimpleCompressionHandler.create(compressionOptions));
        }
        ChannelOperations.addReactiveBridge((Channel)ch, (ChannelOperations.OnSetup)opsFactory, (ConnectionObserver)listener);
        if (metricsRecorder != null && metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler;
            Channel parent = ch.parent();
            ChannelHandler existingHandler = parent.pipeline().get("reactor.left.httpMetricsHandler");
            if (existingHandler != null) {
                if (metricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                    parent.pipeline().replace("reactor.left.httpMetricsHandler", "reactor.left.channelMetricsHandler", (ChannelHandler)new H2ChannelMetricsHandler(metricsRecorder));
                } else {
                    parent.pipeline().remove("reactor.left.httpMetricsHandler");
                }
                handler = metricsRecorder instanceof MicrometerHttpServerMetricsRecorder ? new MicrometerHttpServerMetricsHandler((MicrometerHttpServerMetricsHandler)existingHandler) : (metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsHandler)existingHandler) : new HttpServerMetricsHandler((HttpServerMetricsHandler)existingHandler));
            } else {
                handler = metricsRecorder instanceof MicrometerHttpServerMetricsRecorder ? new MicrometerHttpServerMetricsHandler((MicrometerHttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue) : (metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue));
            }
            pipeline.addBefore("reactor.right.reactiveBridge", "reactor.left.httpMetricsHandler", (ChannelHandler)handler);
        }
        if (errorLogEnabled) {
            pipeline.addBefore("reactor.right.reactiveBridge", "reactor.left.errorLogHandler", (ChannelHandler)new DefaultErrorLogHandler(errorLog));
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)ch, (String)"Initialized HTTP/2 stream pipeline {}"), new Object[]{pipeline});
        }
    }

    static @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, int minResponseSize) {
        if (minResponseSize <= 0) {
            return compressionPredicate;
        }
        BiPredicate<HttpServerRequest, HttpServerResponse> lengthPredicate = (req, res) -> {
            String length = res.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (length == null) {
                return true;
            }
            try {
                return Long.parseLong(length) >= (long)minResponseSize;
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        };
        if (compressionPredicate != null) {
            lengthPredicate = lengthPredicate.and(compressionPredicate);
        }
        return lengthPredicate;
    }

    static void configureHttp3Pipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
        p.remove("reactor.right.reactiveBridge");
        p.addLast("reactor.left.httpCodec", Http3Codec.newHttp3ServerConnectionHandler(accessLogEnabled, accessLog, compressionOptions, compressPredicate, cookieDecoder, cookieEncoder, errorLogEnabled, errorLog, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, listener, mapHandle, methodTagValue, metricsRecorder, minCompressionSize, opsFactory, readTimeout, requestTimeout, uriTagValue, validate));
        if (metricsRecorder != null) {
            p.remove("reactor.left.channelMetricsHandler");
        }
    }

    static void configureH2Pipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, boolean enableGracefulShutdown, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, @Nullable Http2SettingsSpec http2SettingsSpec, HttpMessageLogFactory httpMessageLogFactory, @Nullable Duration idleTimeout, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
        Long maxStreams;
        p.remove("reactor.right.reactiveBridge");
        Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(validate).initialSettings(HttpServerConfig.http2Settings(http2SettingsSpec));
        Long l = maxStreams = http2SettingsSpec != null ? http2SettingsSpec.maxStreams() : null;
        if (enableGracefulShutdown || maxStreams != null) {
            http2FrameCodecBuilder.gracefulShutdownTimeoutMillis(-1L);
        }
        if (p.get("reactor.left.loggingHandler") != null) {
            http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2"));
        }
        Http2FrameCodec http2FrameCodec = http2FrameCodecBuilder.build();
        if (maxStreams != null) {
            http2FrameCodec.connection().addListener((Http2Connection.Listener)new H2ConnectionListener(p.channel(), maxStreams));
        }
        p.addLast("reactor.left.httpCodec", (ChannelHandler)http2FrameCodec).addLast("reactor.left.h2MultiplexHandler", (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new H2Codec(accessLogEnabled, accessLog, compressionOptions, compressPredicate, http2SettingsSpec != null ? http2SettingsSpec.connectProtocolEnabled() : null, cookieDecoder, cookieEncoder, errorLogEnabled, errorLog, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, listener, mapHandle, methodTagValue, metricsRecorder, minCompressionSize, opsFactory, readTimeout, requestTimeout, uriTagValue)));
        IdleTimeoutHandler.addIdleTimeoutHandler(p, idleTimeout);
        if (metricsRecorder != null && metricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
            p.replace("reactor.left.channelMetricsHandler", "reactor.left.channelMetricsHandler", (ChannelHandler)new H2ChannelMetricsHandler(metricsRecorder));
        }
    }

    static void configureHttp11OrH2CleartextPipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, HttpRequestDecoderSpec decoder, boolean enableGracefulShutdown, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, @Nullable Http2SettingsSpec http2SettingsSpec, HttpMessageLogFactory httpMessageLogFactory, @Nullable Duration idleTimeout, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int maxKeepAliveRequests, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue) {
        boolean alwaysCompress;
        HttpDecoderConfig decoderConfig = new HttpDecoderConfig();
        decoderConfig.setMaxInitialLineLength(decoder.maxInitialLineLength()).setMaxHeaderSize(decoder.maxHeaderSize()).setMaxChunkSize(decoder.maxChunkSize()).setValidateHeaders(decoder.validateHeaders()).setInitialBufferSize(decoder.initialBufferSize()).setAllowDuplicateContentLengths(decoder.allowDuplicateContentLengths()).setAllowPartialChunks(decoder.allowPartialChunks());
        HttpServerCodec httpServerCodec = new HttpServerCodec(decoderConfig);
        Http11OrH2CleartextCodec upgrader = new Http11OrH2CleartextCodec(accessLogEnabled, accessLog, compressionOptions, compressPredicate, cookieDecoder, cookieEncoder, p.get("reactor.left.loggingHandler") != null, enableGracefulShutdown, errorLogEnabled, errorLog, formDecoderProvider, forwardedHeaderHandler, http2SettingsSpec, httpMessageLogFactory, listener, mapHandle, methodTagValue, metricsRecorder, minCompressionSize, opsFactory, readTimeout, requestTimeout, uriTagValue, decoder.validateHeaders());
        H2CleartextCodec http2ServerHandler = new H2CleartextCodec(upgrader, http2SettingsSpec != null ? http2SettingsSpec.maxStreams() : null);
        ReactorNettyHttpServerUpgradeHandler httpServerUpgradeHandler = readTimeout == null && requestTimeout == null ? new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, (HttpServerUpgradeHandler.UpgradeCodecFactory)upgrader, decoder.h2cMaxContentLength()) : new ReactorNettyHttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, upgrader, decoder.h2cMaxContentLength(), readTimeout, requestTimeout);
        CleartextHttp2ServerUpgradeHandler h2cUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(httpServerCodec, (HttpServerUpgradeHandler)httpServerUpgradeHandler, (ChannelHandler)http2ServerHandler);
        p.addBefore("reactor.right.reactiveBridge", "reactor.left.h2cUpgradeHandler", (ChannelHandler)h2cUpgradeHandler).addBefore("reactor.right.reactiveBridge", "reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(compressPredicate, compressionOptions, cookieDecoder, cookieEncoder, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, idleTimeout, listener, mapHandle, maxKeepAliveRequests, readTimeout, requestTimeout, decoder.validateHeaders()));
        if (accessLogEnabled) {
            p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.accessLogHandler", AccessLogHandlerFactory.H1.create(accessLog));
        }
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            p.addBefore("reactor.left.httpTrafficHandler", "reactor.left.compressionHandler", (ChannelHandler)SimpleCompressionHandler.create(compressionOptions));
        }
        if (metricsRecorder != null && metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler = metricsRecorder instanceof MicrometerHttpServerMetricsRecorder ? new MicrometerHttpServerMetricsHandler((MicrometerHttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue) : (metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue));
            p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", (ChannelHandler)handler);
            if (metricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                p.remove("reactor.left.channelMetricsHandler");
            }
        }
        if (errorLogEnabled) {
            p.addBefore("reactor.right.reactiveBridge", "reactor.left.errorLogHandler", (ChannelHandler)new DefaultErrorLogHandler(errorLog));
        }
    }

    static void configureHttp11Pipeline(ChannelPipeline p, boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, boolean channelOpened, HttpRequestDecoderSpec decoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, @Nullable Duration idleTimeout, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int maxKeepAliveRequests, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue) {
        boolean alwaysCompress;
        HttpDecoderConfig decoderConfig = new HttpDecoderConfig();
        decoderConfig.setMaxInitialLineLength(decoder.maxInitialLineLength()).setMaxHeaderSize(decoder.maxHeaderSize()).setMaxChunkSize(decoder.maxChunkSize()).setValidateHeaders(decoder.validateHeaders()).setInitialBufferSize(decoder.initialBufferSize()).setAllowDuplicateContentLengths(decoder.allowDuplicateContentLengths()).setAllowPartialChunks(decoder.allowPartialChunks());
        p.addBefore("reactor.right.reactiveBridge", "reactor.left.httpCodec", (ChannelHandler)new HttpServerCodec(decoderConfig)).addBefore("reactor.right.reactiveBridge", "reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(compressPredicate, compressionOptions, cookieDecoder, cookieEncoder, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, idleTimeout, listener, mapHandle, maxKeepAliveRequests, readTimeout, requestTimeout, decoder.validateHeaders()));
        if (accessLogEnabled) {
            p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.accessLogHandler", AccessLogHandlerFactory.H1.create(accessLog));
        }
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            p.addBefore("reactor.left.httpTrafficHandler", "reactor.left.compressionHandler", (ChannelHandler)SimpleCompressionHandler.create(compressionOptions));
        }
        if (metricsRecorder != null && metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler = metricsRecorder instanceof MicrometerHttpServerMetricsRecorder ? new MicrometerHttpServerMetricsHandler((MicrometerHttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue) : (metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)metricsRecorder, methodTagValue, uriTagValue));
            if (channelOpened) {
                handler.channelOpened = true;
            }
            p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", (ChannelHandler)handler);
            if (metricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                p.remove("reactor.left.channelMetricsHandler");
            }
        }
        if (errorLogEnabled) {
            p.addBefore("reactor.right.reactiveBridge", "reactor.left.errorLogHandler", (ChannelHandler)new DefaultErrorLogHandler(errorLog));
        }
    }

    static final class ReactorNettyHttpServerUpgradeHandler
    extends HttpServerUpgradeHandler {
        final @Nullable Duration readTimeout;
        final @Nullable Duration requestTimeout;
        boolean requestAvailable;
        @Nullable Future<?> requestTimeoutFuture;

        ReactorNettyHttpServerUpgradeHandler(HttpServerUpgradeHandler.SourceCodec sourceCodec, HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory, int maxContentLength, @Nullable Duration readTimeout, @Nullable Duration requestTimeout) {
            super(sourceCodec, upgradeCodecFactory, maxContentLength);
            this.readTimeout = readTimeout;
            this.requestTimeout = requestTimeout;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.requestAvailable = true;
            this.stopTimeouts(ctx);
            super.handlerRemoved(ctx);
        }

        protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
            HttpRequest req;
            if (msg instanceof HttpRequest && (req = (HttpRequest)msg).headers().contains((CharSequence)HttpHeaderNames.UPGRADE)) {
                if (this.readTimeout != null) {
                    ctx.channel().pipeline().addFirst("reactor.left.readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS));
                }
                if (this.requestTimeout != null) {
                    this.requestTimeoutFuture = ctx.executor().schedule((Runnable)new RequestTimeoutTask(ctx), Math.max(this.requestTimeout.toMillis(), 1L), TimeUnit.MILLISECONDS);
                }
            }
            super.decode(ctx, msg, out);
            if (!out.isEmpty()) {
                this.requestAvailable = true;
                this.stopTimeouts(ctx);
            }
        }

        void stopTimeouts(ChannelHandlerContext ctx) {
            ChannelHandler handler;
            if (this.readTimeout != null && (handler = ctx.channel().pipeline().get("reactor.left.readTimeoutHandler")) != null) {
                ctx.channel().pipeline().remove(handler);
            }
            if (this.requestTimeoutFuture != null) {
                this.requestTimeoutFuture.cancel(false);
                this.requestTimeoutFuture = null;
            }
        }

        final class RequestTimeoutTask
        implements Runnable {
            final ChannelHandlerContext ctx;

            RequestTimeoutTask(ChannelHandlerContext ctx) {
                this.ctx = ctx;
            }

            @Override
            public void run() {
                if (!ReactorNettyHttpServerUpgradeHandler.this.requestAvailable) {
                    this.ctx.fireExceptionCaught((Throwable)((Object)RequestTimeoutException.requestTimedOut()));
                    this.ctx.close();
                }
            }
        }
    }

    static final class ProtocolHeaderHandler
    extends ChannelInboundHandlerAdapter {
        static final ProtocolHeaderHandler INSTANCE = new ProtocolHeaderHandler();
        static final String NAME = "reactor.left.protocolHeaderHandler";

        ProtocolHeaderHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof Http2HeadersFrame) {
                Http2Headers headers = ((Http2HeadersFrame)msg).headers();
                CharSequence value = (CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PROTOCOL.value());
                if (value != null) {
                    headers.set((Object)"x-http2-protocol", (Object)value);
                    headers.set((Object)"x-http2-path", (Object)headers.path());
                }
                ctx.pipeline().remove((ChannelHandler)this);
            }
            ctx.fireChannelRead(msg);
        }

        public boolean isSharable() {
            return true;
        }
    }

    static final class HttpServerChannelInitializer
    implements ChannelPipelineConfigurer {
        final boolean accessLogEnabled;
        final @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;
        final @Nullable HttpCompressionOptionsSpec compressionOptions;
        final @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final HttpRequestDecoderSpec decoder;
        final boolean enableGracefulShutdown;
        final boolean errorLogEnabled;
        final @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final @Nullable Http2SettingsSpec http2SettingsSpec;
        final HttpMessageLogFactory httpMessageLogFactory;
        final @Nullable Duration idleTimeout;
        final @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final int maxKeepAliveRequests;
        final @Nullable Function<String, String> methodTagValue;
        final @Nullable ChannelMetricsRecorder metricsRecorder;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;
        final int protocols;
        final ProxyProtocolSupportType proxyProtocolSupportType;
        final boolean redirectHttpToHttps;
        final @Nullable SslProvider sslProvider;
        final @Nullable Duration readTimeout;
        final @Nullable Duration requestTimeout;
        final @Nullable Function<String, String> uriTagValue;

        HttpServerChannelInitializer(HttpServerConfig config) {
            this.accessLogEnabled = config.accessLogEnabled;
            this.accessLog = config.accessLog;
            this.compressionOptions = config.compressionOptions;
            this.compressPredicate = config.compressPredicate;
            this.cookieDecoder = config.cookieDecoder;
            this.cookieEncoder = config.cookieEncoder;
            this.decoder = config.decoder;
            this.enableGracefulShutdown = config.channelGroup() != null;
            this.errorLogEnabled = config.errorLogEnabled;
            this.errorLog = config.errorLog;
            this.formDecoderProvider = config.formDecoderProvider;
            this.forwardedHeaderHandler = config.forwardedHeaderHandler;
            this.http2SettingsSpec = config.http2Settings;
            this.httpMessageLogFactory = config.httpMessageLogFactory;
            this.idleTimeout = config.idleTimeout;
            this.mapHandle = config.mapHandle;
            this.maxKeepAliveRequests = config.maxKeepAliveRequests;
            this.methodTagValue = config.methodTagValue;
            this.metricsRecorder = config.metricsRecorderInternal();
            this.minCompressionSize = config.minCompressionSize;
            this.opsFactory = config.channelOperationsProvider();
            this.protocols = config._protocols;
            this.proxyProtocolSupportType = config.proxyProtocolSupportType;
            this.readTimeout = config.readTimeout;
            this.redirectHttpToHttps = config.redirectHttpToHttps;
            this.requestTimeout = config.requestTimeout;
            this.sslProvider = config.sslProvider;
            this.uriTagValue = config.uriTagValue;
        }

        public void onChannelInit(ConnectionObserver observer, Channel channel, @Nullable SocketAddress remoteAddress) {
            boolean needRead = false;
            if (this.sslProvider != null) {
                ChannelPipeline pipeline = channel.pipeline();
                if ((this.protocols & 8) != 8) {
                    if (this.redirectHttpToHttps && (this.protocols & 2) != 2) {
                        NonSslRedirectDetector nonSslRedirectDetector = new NonSslRedirectDetector(this.sslProvider, remoteAddress, SSL_DEBUG);
                        pipeline.addFirst("reactor.left.nonSslRedirectDetector", (ChannelHandler)nonSslRedirectDetector);
                    } else {
                        this.sslProvider.addSslHandler(channel, remoteAddress, SSL_DEBUG);
                    }
                }
                if ((this.protocols & 6) == 6) {
                    channel.pipeline().addBefore("reactor.right.reactiveBridge", "reactor.left.h2OrHttp11Codec", (ChannelHandler)new H2OrHttp11Codec(this, observer));
                } else if ((this.protocols & 4) == 4) {
                    HttpServerConfig.configureHttp11Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, this.compressionOptions, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, false, this.decoder, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.idleTimeout, observer, this.mapHandle, this.maxKeepAliveRequests, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.readTimeout, this.requestTimeout, this.uriTagValue);
                } else if ((this.protocols & 2) == 2) {
                    ChannelHandler sslHandler = channel.pipeline().get("reactor.left.sslHandler");
                    if (sslHandler instanceof AbstractSniHandler) {
                        channel.pipeline().addBefore("reactor.right.reactiveBridge", "reactor.left.h2OrHttp11Codec", (ChannelHandler)new H2OrHttp11Codec(this, observer, true));
                    } else {
                        HttpServerConfig.configureH2Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, this.compressionOptions, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.enableGracefulShutdown, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2SettingsSpec, this.httpMessageLogFactory, this.idleTimeout, observer, this.mapHandle, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue, this.decoder.validateHeaders());
                    }
                } else if ((this.protocols & 8) == 8) {
                    HttpServerConfig.configureHttp3Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, this.compressionOptions, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, observer, this.mapHandle, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue, this.decoder.validateHeaders());
                }
            } else if ((this.protocols & 5) == 5) {
                HttpServerConfig.configureHttp11OrH2CleartextPipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, this.compressionOptions, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.decoder, this.enableGracefulShutdown, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2SettingsSpec, this.httpMessageLogFactory, this.idleTimeout, observer, this.mapHandle, this.maxKeepAliveRequests, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue);
            } else if ((this.protocols & 4) == 4) {
                HttpServerConfig.configureHttp11Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, this.compressionOptions, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, false, this.decoder, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.idleTimeout, observer, this.mapHandle, this.maxKeepAliveRequests, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.readTimeout, this.requestTimeout, this.uriTagValue);
            } else if ((this.protocols & 1) == 1) {
                HttpServerConfig.configureH2Pipeline(channel.pipeline(), this.accessLogEnabled, this.accessLog, this.compressionOptions, HttpServerConfig.compressPredicate(this.compressPredicate, this.minCompressionSize), this.cookieDecoder, this.cookieEncoder, this.enableGracefulShutdown, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2SettingsSpec, this.httpMessageLogFactory, this.idleTimeout, observer, this.mapHandle, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue, this.decoder.validateHeaders());
                needRead = true;
            }
            if (this.proxyProtocolSupportType == ProxyProtocolSupportType.ON) {
                channel.pipeline().addFirst("reactor.left.proxyProtocolDecoder", (ChannelHandler)new HAProxyMessageDecoder()).addAfter("reactor.left.proxyProtocolDecoder", "reactor.left.proxyProtocolReader", (ChannelHandler)new HAProxyMessageReader());
            } else if (this.proxyProtocolSupportType == ProxyProtocolSupportType.AUTO) {
                channel.pipeline().addFirst("reactor.left.proxyProtocolDecoder", (ChannelHandler)new HAProxyMessageDetector());
            }
            if (needRead) {
                channel.read();
            }
        }
    }

    static final class H2OrHttp11Codec
    extends ApplicationProtocolNegotiationHandler {
        final boolean accessLogEnabled;
        final @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;
        final @Nullable HttpCompressionOptionsSpec compressionOptions;
        final @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final HttpRequestDecoderSpec decoder;
        final boolean enableGracefulShutdown;
        final boolean errorLogEnabled;
        final @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final @Nullable Http2SettingsSpec http2SettingsSpec;
        final HttpMessageLogFactory httpMessageLogFactory;
        final @Nullable Duration idleTimeout;
        final ConnectionObserver listener;
        final @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final int maxKeepAliveRequests;
        final @Nullable Function<String, String> methodTagValue;
        final @Nullable ChannelMetricsRecorder metricsRecorder;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;
        final @Nullable Duration readTimeout;
        final @Nullable Duration requestTimeout;
        final boolean supportOnlyHttp2;
        final @Nullable Function<String, String> uriTagValue;

        H2OrHttp11Codec(HttpServerChannelInitializer initializer, ConnectionObserver listener) {
            this(initializer, listener, false);
        }

        H2OrHttp11Codec(HttpServerChannelInitializer initializer, ConnectionObserver listener, boolean supportOnlyHttp2) {
            super("http/1.1");
            this.accessLogEnabled = initializer.accessLogEnabled;
            this.accessLog = initializer.accessLog;
            this.compressionOptions = initializer.compressionOptions;
            this.compressPredicate = HttpServerConfig.compressPredicate(initializer.compressPredicate, initializer.minCompressionSize);
            this.cookieDecoder = initializer.cookieDecoder;
            this.cookieEncoder = initializer.cookieEncoder;
            this.decoder = initializer.decoder;
            this.enableGracefulShutdown = initializer.enableGracefulShutdown;
            this.errorLogEnabled = initializer.errorLogEnabled;
            this.errorLog = initializer.errorLog;
            this.formDecoderProvider = initializer.formDecoderProvider;
            this.forwardedHeaderHandler = initializer.forwardedHeaderHandler;
            this.http2SettingsSpec = initializer.http2SettingsSpec;
            this.httpMessageLogFactory = initializer.httpMessageLogFactory;
            this.idleTimeout = initializer.idleTimeout;
            this.listener = listener;
            this.mapHandle = initializer.mapHandle;
            this.maxKeepAliveRequests = initializer.maxKeepAliveRequests;
            this.methodTagValue = initializer.methodTagValue;
            this.metricsRecorder = initializer.metricsRecorder;
            this.minCompressionSize = initializer.minCompressionSize;
            this.opsFactory = initializer.opsFactory;
            this.readTimeout = initializer.readTimeout;
            this.requestTimeout = initializer.requestTimeout;
            this.supportOnlyHttp2 = supportOnlyHttp2;
            this.uriTagValue = initializer.uriTagValue;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)("Negotiated application-level protocol [" + protocol + "]")));
            }
            ChannelPipeline p = ctx.pipeline();
            if ("h2".equals(protocol)) {
                HttpServerConfig.configureH2Pipeline(p, this.accessLogEnabled, this.accessLog, this.compressionOptions, this.compressPredicate, this.cookieDecoder, this.cookieEncoder, this.enableGracefulShutdown, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.http2SettingsSpec, this.httpMessageLogFactory, this.idleTimeout, this.listener, this.mapHandle, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue, this.decoder.validateHeaders());
                return;
            }
            if (!this.supportOnlyHttp2 && "http/1.1".equals(protocol)) {
                HttpServerConfig.configureHttp11Pipeline(p, this.accessLogEnabled, this.accessLog, this.compressionOptions, this.compressPredicate, this.cookieDecoder, this.cookieEncoder, true, this.decoder, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.idleTimeout, this.listener, this.mapHandle, this.maxKeepAliveRequests, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.readTimeout, this.requestTimeout, this.uriTagValue);
                IdleTimeoutHandler.addIdleTimeoutHandler(ctx.pipeline(), this.idleTimeout);
                return;
            }
            throw new IllegalStateException("unknown protocol: " + protocol);
        }
    }

    static final class H2ConnectionListener
    extends Http2ConnectionAdapter {
        final Channel channel;
        final long maxStreams;
        long numStreams;

        H2ConnectionListener(Channel channel, long maxStreams) {
            this.channel = channel;
            this.maxStreams = maxStreams;
        }

        public void onStreamActive(Http2Stream stream) {
            assert (this.channel.eventLoop().inEventLoop());
            if (++this.numStreams == this.maxStreams) {
                this.channel.close();
            }
        }
    }

    static final class Http11OrH2CleartextCodec
    extends ChannelInitializer<Channel>
    implements HttpServerUpgradeHandler.UpgradeCodecFactory {
        final boolean accessLogEnabled;
        final @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;
        final @Nullable HttpCompressionOptionsSpec compressionOptions;
        final @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final @Nullable Boolean connectProtocolEnabled;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final boolean errorLogEnabled;
        final @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final Http2FrameCodec http2FrameCodec;
        final HttpMessageLogFactory httpMessageLogFactory;
        final ConnectionObserver listener;
        final @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final @Nullable Long maxStreams;
        final @Nullable Function<String, String> methodTagValue;
        final @Nullable ChannelMetricsRecorder metricsRecorder;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;
        final @Nullable Duration readTimeout;
        final @Nullable Duration requestTimeout;
        final @Nullable Function<String, String> uriTagValue;

        Http11OrH2CleartextCodec(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder cookieDecoder, ServerCookieEncoder cookieEncoder, boolean debug, boolean enableGracefulShutdown, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, @Nullable Http2SettingsSpec http2SettingsSpec, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
            this.accessLogEnabled = accessLogEnabled;
            this.accessLog = accessLog;
            this.compressionOptions = compressionOptions;
            this.compressPredicate = compressPredicate;
            this.connectProtocolEnabled = http2SettingsSpec != null ? http2SettingsSpec.connectProtocolEnabled() : null;
            this.cookieDecoder = cookieDecoder;
            this.cookieEncoder = cookieEncoder;
            this.errorLogEnabled = errorLogEnabled;
            this.errorLog = errorLog;
            this.formDecoderProvider = formDecoderProvider;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(validate).initialSettings(HttpServerConfig.http2Settings(http2SettingsSpec));
            Long l = this.maxStreams = http2SettingsSpec != null ? http2SettingsSpec.maxStreams() : null;
            if (enableGracefulShutdown || this.maxStreams != null) {
                http2FrameCodecBuilder.gracefulShutdownTimeoutMillis(-1L);
            }
            if (debug) {
                http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2"));
            }
            this.http2FrameCodec = http2FrameCodecBuilder.build();
            this.httpMessageLogFactory = httpMessageLogFactory;
            this.listener = listener;
            this.mapHandle = mapHandle;
            this.methodTagValue = methodTagValue;
            this.metricsRecorder = metricsRecorder;
            this.minCompressionSize = minCompressionSize;
            this.opsFactory = opsFactory;
            this.readTimeout = readTimeout;
            this.requestTimeout = requestTimeout;
            this.uriTagValue = uriTagValue;
        }

        protected void initChannel(Channel ch) {
            ch.pipeline().remove((ChannelHandler)this);
            HttpServerConfig.addStreamHandlers(ch, this.accessLogEnabled, this.accessLog, this.compressionOptions, this.compressPredicate, this.connectProtocolEnabled, this.cookieDecoder, this.cookieEncoder, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.listener, this.mapHandle, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(this.http2FrameCodec, new ChannelHandler[]{new H2CleartextCodec(this, false, false, this.maxStreams)});
            }
            return null;
        }
    }

    static final class H2Codec
    extends ChannelInitializer<Channel> {
        final boolean accessLogEnabled;
        final @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;
        final @Nullable HttpCompressionOptionsSpec compressionOptions;
        final @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final @Nullable Boolean connectProtocolEnabled;
        final ServerCookieDecoder cookieDecoder;
        final ServerCookieEncoder cookieEncoder;
        final boolean errorLogEnabled;
        final @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog;
        final HttpServerFormDecoderProvider formDecoderProvider;
        final @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final HttpMessageLogFactory httpMessageLogFactory;
        final ConnectionObserver listener;
        final @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
        final @Nullable Function<String, String> methodTagValue;
        final @Nullable ChannelMetricsRecorder metricsRecorder;
        final int minCompressionSize;
        final ChannelOperations.OnSetup opsFactory;
        final @Nullable Duration readTimeout;
        final @Nullable Duration requestTimeout;
        final @Nullable Function<String, String> uriTagValue;

        H2Codec(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable Boolean connectProtocolEnabled, ServerCookieDecoder decoder, ServerCookieEncoder encoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue) {
            this.accessLogEnabled = accessLogEnabled;
            this.accessLog = accessLog;
            this.compressionOptions = compressionOptions;
            this.compressPredicate = compressPredicate;
            this.connectProtocolEnabled = connectProtocolEnabled;
            this.cookieDecoder = decoder;
            this.cookieEncoder = encoder;
            this.errorLogEnabled = errorLogEnabled;
            this.errorLog = errorLog;
            this.formDecoderProvider = formDecoderProvider;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.httpMessageLogFactory = httpMessageLogFactory;
            this.listener = listener;
            this.mapHandle = mapHandle;
            this.methodTagValue = methodTagValue;
            this.metricsRecorder = metricsRecorder;
            this.minCompressionSize = minCompressionSize;
            this.opsFactory = opsFactory;
            this.readTimeout = readTimeout;
            this.requestTimeout = requestTimeout;
            this.uriTagValue = uriTagValue;
        }

        protected void initChannel(Channel ch) {
            ch.pipeline().remove((ChannelHandler)this);
            HttpServerConfig.addStreamHandlers(ch, this.accessLogEnabled, this.accessLog, this.compressionOptions, this.compressPredicate, this.connectProtocolEnabled, this.cookieDecoder, this.cookieEncoder, this.errorLogEnabled, this.errorLog, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.listener, this.mapHandle, this.methodTagValue, this.metricsRecorder, this.minCompressionSize, this.opsFactory, this.readTimeout, this.requestTimeout, this.uriTagValue);
        }
    }

    static final class H2CleartextCodec
    extends ChannelHandlerAdapter {
        final Http11OrH2CleartextCodec upgrader;
        final boolean addHttp2FrameCodec;
        final boolean removeMetricsHandler;
        final @Nullable Long maxStreams;

        H2CleartextCodec(Http11OrH2CleartextCodec upgrader, @Nullable Long maxStreams) {
            this(upgrader, true, true, maxStreams);
        }

        H2CleartextCodec(Http11OrH2CleartextCodec upgrader, boolean addHttp2FrameCodec, boolean removeMetricsHandler, @Nullable Long maxStreams) {
            this.upgrader = upgrader;
            this.addHttp2FrameCodec = addHttp2FrameCodec;
            this.removeMetricsHandler = removeMetricsHandler;
            this.maxStreams = maxStreams;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            if (this.maxStreams != null) {
                this.upgrader.http2FrameCodec.connection().addListener((Http2Connection.Listener)new H2ConnectionListener(ctx.channel(), this.maxStreams));
            }
            if (this.addHttp2FrameCodec) {
                pipeline.addAfter(ctx.name(), "reactor.left.httpCodec", (ChannelHandler)this.upgrader.http2FrameCodec);
            }
            pipeline.addLast("reactor.left.h2MultiplexHandler", (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)this.upgrader));
            pipeline.remove((ChannelHandler)this);
            if (pipeline.get("reactor.left.accessLogHandler") != null) {
                pipeline.remove("reactor.left.accessLogHandler");
            }
            if (pipeline.get("reactor.left.compressionHandler") != null) {
                pipeline.remove("reactor.left.compressionHandler");
            }
            if (this.removeMetricsHandler && pipeline.get("reactor.left.httpMetricsHandler") != null) {
                AbstractHttpServerMetricsHandler handler = (AbstractHttpServerMetricsHandler)pipeline.get("reactor.left.httpMetricsHandler");
                if (handler.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                    pipeline.replace("reactor.left.httpMetricsHandler", "reactor.left.channelMetricsHandler", (ChannelHandler)new H2ChannelMetricsHandler(handler.recorder()));
                } else {
                    pipeline.remove("reactor.left.httpMetricsHandler");
                }
            }
            pipeline.remove("reactor.left.httpTrafficHandler");
            pipeline.remove("reactor.right.reactiveBridge");
        }
    }

    static final class H2ChannelMetricsHandler
    extends AbstractChannelMetricsHandler {
        final ChannelMetricsRecorder recorder;

        H2ChannelMetricsHandler(ChannelMetricsRecorder recorder) {
            super(null, true);
            this.recorder = recorder;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            ctx.fireChannelRegistered();
        }

        public ChannelHandler connectMetricsHandler() {
            return null;
        }

        public ChannelHandler tlsMetricsHandler() {
            return null;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        public ChannelMetricsRecorder recorder() {
            return this.recorder;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise);
        }
    }
}

