/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class HttpServerFormDecoderProvider {
    final @Nullable Path baseDirectory;
    final Charset charset;
    final long maxInMemorySize;
    final long maxSize;
    final Scheduler scheduler;
    final boolean streaming;
    private volatile Mono<Path> defaultTempDirectory = this.createDefaultTempDirectory();
    static final HttpServerFormDecoderProvider DEFAULT_FORM_DECODER_SPEC = new Build().build();
    static final String DEFAULT_TEMP_DIRECTORY_PREFIX = "RN_form_";

    HttpServerFormDecoderProvider(Build build) {
        this.baseDirectory = build.baseDirectory;
        this.charset = build.charset;
        this.maxInMemorySize = !build.streaming ? build.maxInMemorySize : -1L;
        this.maxSize = build.maxSize;
        this.scheduler = build.scheduler;
        this.streaming = build.streaming;
    }

    public @Nullable Path baseDirectory() {
        return this.baseDirectory;
    }

    public Charset charset() {
        return this.charset;
    }

    public long maxInMemorySize() {
        return this.maxInMemorySize;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public boolean streaming() {
        return this.streaming;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpServerFormDecoderProvider)) {
            return false;
        }
        HttpServerFormDecoderProvider that = (HttpServerFormDecoderProvider)o;
        return this.maxInMemorySize == that.maxInMemorySize && this.maxSize == that.maxSize && this.streaming == that.streaming && Objects.equals(this.baseDirectory, that.baseDirectory) && this.charset.equals(that.charset) && this.scheduler.equals(that.scheduler);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.baseDirectory);
        result = 31 * result + Objects.hashCode(this.charset);
        result = 31 * result + Long.hashCode(this.maxInMemorySize);
        result = 31 * result + Long.hashCode(this.maxSize);
        result = 31 * result + Objects.hashCode(this.scheduler);
        result = 31 * result + Boolean.hashCode(this.streaming);
        return result;
    }

    Mono<Path> createDefaultTempDirectory() {
        return Mono.fromCallable(() -> Files.createTempDirectory(DEFAULT_TEMP_DIRECTORY_PREFIX, new FileAttribute[0])).cache();
    }

    Mono<Path> defaultTempDirectory() {
        return this.defaultTempDirectory.flatMap(dir -> {
            if (!Files.exists(dir, new LinkOption[0])) {
                Mono<Path> newDirectory = this.createDefaultTempDirectory();
                this.defaultTempDirectory = newDirectory;
                return newDirectory;
            }
            return Mono.just((Object)dir);
        }).subscribeOn(this.scheduler);
    }

    Mono<ReactorNettyHttpPostRequestDecoder> newHttpPostRequestDecoder(HttpRequest request, boolean isMultipart) {
        if (this.maxInMemorySize > -1L) {
            Mono directoryMono = this.baseDirectory == null ? this.defaultTempDirectory() : Mono.just((Object)this.baseDirectory);
            return directoryMono.map(directory -> this.createNewHttpPostRequestDecoder(request, isMultipart, (Path)directory));
        }
        return Mono.just((Object)this.createNewHttpPostRequestDecoder(request, isMultipart, null));
    }

    ReactorNettyHttpPostRequestDecoder createNewHttpPostRequestDecoder(HttpRequest request, boolean isMultipart, @Nullable Path baseDirectory) {
        DefaultHttpDataFactory factory = this.maxInMemorySize > 0L ? new DefaultHttpDataFactory(this.maxInMemorySize, this.charset) : new DefaultHttpDataFactory(this.maxInMemorySize == 0L, this.charset);
        factory.setMaxLimit(this.maxSize);
        if (baseDirectory != null) {
            factory.setBaseDir(baseDirectory.toFile().getAbsolutePath());
        }
        return isMultipart ? new ReactorNettyHttpPostMultipartRequestDecoder((HttpDataFactory)factory, request) : new ReactorNettyHttpPostStandardRequestDecoder((HttpDataFactory)factory, request);
    }

    static final class ReactorNettyHttpPostStandardRequestDecoder
    extends HttpPostStandardRequestDecoder
    implements ReactorNettyHttpPostRequestDecoder {
        final List<HttpData> currentCompletedHttpData = new ArrayList<HttpData>();

        ReactorNettyHttpPostStandardRequestDecoder(HttpDataFactory factory, HttpRequest request) {
            super(factory, request);
        }

        protected void addHttpData(InterfaceHttpData data) {
            if (data instanceof HttpData) {
                this.currentCompletedHttpData.add((HttpData)data);
            }
        }

        @Override
        public void cleanCurrentHttpData(boolean onlyCompleted) {
            InterfaceHttpData partial;
            for (HttpData data : this.currentCompletedHttpData) {
                this.removeHttpDataFromClean((InterfaceHttpData)data);
                data.release();
            }
            this.currentCompletedHttpData.clear();
            if (!onlyCompleted && (partial = this.currentPartialHttpData()) instanceof HttpData) {
                ((HttpData)partial).delete();
            }
        }

        @Override
        public List<HttpData> currentHttpData(boolean onlyCompleted) {
            InterfaceHttpData partial;
            if (!onlyCompleted && (partial = this.currentPartialHttpData()) instanceof HttpData) {
                this.currentCompletedHttpData.add(((HttpData)partial).retainedDuplicate());
            }
            return this.currentCompletedHttpData;
        }

        public void destroy() {
            super.destroy();
            InterfaceHttpData partial = this.currentPartialHttpData();
            if (partial != null) {
                partial.release();
            }
        }
    }

    static final class ReactorNettyHttpPostMultipartRequestDecoder
    extends HttpPostMultipartRequestDecoder
    implements ReactorNettyHttpPostRequestDecoder {
        final List<HttpData> currentCompletedHttpData = new ArrayList<HttpData>();

        ReactorNettyHttpPostMultipartRequestDecoder(HttpDataFactory factory, HttpRequest request) {
            super(factory, request);
        }

        protected void addHttpData(InterfaceHttpData data) {
            if (data instanceof HttpData) {
                this.currentCompletedHttpData.add((HttpData)data);
            }
        }

        @Override
        public void cleanCurrentHttpData(boolean onlyCompleted) {
            InterfaceHttpData partial;
            for (HttpData data : this.currentCompletedHttpData) {
                this.removeHttpDataFromClean((InterfaceHttpData)data);
                data.release();
            }
            this.currentCompletedHttpData.clear();
            if (!onlyCompleted && (partial = this.currentPartialHttpData()) instanceof HttpData) {
                ((HttpData)partial).delete();
            }
        }

        @Override
        public List<HttpData> currentHttpData(boolean onlyCompleted) {
            InterfaceHttpData partial;
            if (!onlyCompleted && (partial = this.currentPartialHttpData()) instanceof HttpData) {
                this.currentCompletedHttpData.add(((HttpData)partial).retainedDuplicate());
            }
            return this.currentCompletedHttpData;
        }

        public void destroy() {
            super.destroy();
            InterfaceHttpData partial = this.currentPartialHttpData();
            if (partial != null) {
                partial.release();
            }
        }
    }

    static final class Build
    implements Builder {
        static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
        static final long DEFAULT_MAX_IN_MEMORY_SIZE = 16384L;
        static final long DEFAULT_MAX_SIZE = -1L;
        static final Scheduler DEFAULT_SCHEDULER = Schedulers.boundedElastic();
        static final boolean DEFAULT_STREAMING = false;
        @Nullable Path baseDirectory;
        Charset charset = DEFAULT_CHARSET;
        long maxInMemorySize = 16384L;
        long maxSize = -1L;
        Scheduler scheduler = DEFAULT_SCHEDULER;
        boolean streaming = false;

        Build() {
        }

        @Override
        public Builder baseDirectory(Path baseDirectory) {
            this.baseDirectory = Objects.requireNonNull(baseDirectory, "baseDirectory");
            return this;
        }

        @Override
        public Builder charset(Charset charset) {
            this.charset = Objects.requireNonNull(charset, "charset");
            return this;
        }

        @Override
        public Builder maxInMemorySize(long maxInMemorySize) {
            if (maxInMemorySize < -1L) {
                throw new IllegalArgumentException("Maximum in-memory size must be greater or equal to -1");
            }
            this.maxInMemorySize = maxInMemorySize;
            return this;
        }

        @Override
        public Builder maxSize(long maxSize) {
            if (maxSize < -1L) {
                throw new IllegalArgumentException("Maximum size must be be greater or equal to -1");
            }
            this.maxSize = maxSize;
            return this;
        }

        @Override
        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
            return this;
        }

        @Override
        public Builder streaming(boolean enable) {
            this.streaming = enable;
            return this;
        }

        HttpServerFormDecoderProvider build() {
            return new HttpServerFormDecoderProvider(this);
        }
    }

    static interface ReactorNettyHttpPostRequestDecoder
    extends InterfaceHttpPostRequestDecoder {
        public void cleanCurrentHttpData(boolean var1);

        public List<HttpData> currentHttpData(boolean var1);
    }

    public static interface Builder {
        public Builder baseDirectory(Path var1);

        public Builder charset(Charset var1);

        public Builder maxInMemorySize(long var1);

        public Builder maxSize(long var1);

        public Builder scheduler(Scheduler var1);

        public Builder streaming(boolean var1);
    }
}

