/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslEngine;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import org.jspecify.annotations.Nullable;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.Http3SettingsSpec;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.tcp.SslProvider;

final class Http3ChannelInitializer
extends ChannelInitializer<Channel> {
    final @Nullable Http3SettingsSpec http3Settings;
    final @Nullable ChannelHandler loggingHandler;
    final ConnectionObserver obs;
    final ChannelOperations.OnSetup opsFactory;
    final ChannelInitializer<Channel> quicChannelInitializer;
    final @Nullable SocketAddress remoteAddress;
    final @Nullable SslProvider sslProvider;

    Http3ChannelInitializer(HttpClientConfig config, ChannelInitializer<Channel> quicChannelInitializer, ConnectionObserver obs, @Nullable SocketAddress remoteAddress) {
        this.http3Settings = config.http3SettingsSpec();
        this.loggingHandler = config.loggingHandler();
        this.obs = obs;
        this.opsFactory = config.channelOperationsProvider();
        this.quicChannelInitializer = quicChannelInitializer;
        this.remoteAddress = remoteAddress;
        this.sslProvider = config.sslProvider;
    }

    protected void initChannel(Channel channel) {
        QuicClientCodecBuilder quicClientCodecBuilder = Http3.newQuicClientCodecBuilder();
        quicClientCodecBuilder.sslEngineProvider(ch -> {
            QuicSslEngine engine;
            if (this.sslProvider == null || !(this.sslProvider.getSslContext() instanceof QuicSslContext)) {
                throw new IllegalArgumentException("The configured SslContext is not QuicSslContext");
            }
            QuicSslContext quicSslContext = (QuicSslContext)this.sslProvider.getSslContext();
            if (this.remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress sniInfo = (InetSocketAddress)this.remoteAddress;
                if (this.sslProvider.getServerNames() != null && !this.sslProvider.getServerNames().isEmpty()) {
                    SNIServerName serverName = (SNIServerName)this.sslProvider.getServerNames().get(0);
                    String serverNameStr = serverName instanceof SNIHostName ? ((SNIHostName)serverName).getAsciiName() : new String(serverName.getEncoded(), StandardCharsets.US_ASCII);
                    engine = quicSslContext.newEngine(ch.alloc(), serverNameStr, sniInfo.getPort());
                } else {
                    engine = quicSslContext.newEngine(ch.alloc(), sniInfo.getHostString(), sniInfo.getPort());
                }
            } else {
                engine = quicSslContext.newEngine(ch.alloc());
            }
            return engine;
        });
        if (this.http3Settings != null) {
            ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)quicClientCodecBuilder.initialMaxData(this.http3Settings.maxData())).initialMaxStreamDataBidirectionalLocal(this.http3Settings.maxStreamDataBidirectionalLocal())).initialMaxStreamDataBidirectionalRemote(this.http3Settings.maxStreamDataBidirectionalRemote())).initialMaxStreamsBidirectional(this.http3Settings.maxStreamsBidirectional());
            if (this.http3Settings.idleTimeout() != null) {
                quicClientCodecBuilder.maxIdleTimeout(this.http3Settings.idleTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        if (this.loggingHandler != null) {
            channel.pipeline().addLast("reactor.left.loggingHandler", this.loggingHandler);
        }
        channel.pipeline().addLast(new ChannelHandler[]{quicClientCodecBuilder.build()});
        channel.pipeline().addLast("reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(this.obs, (ChannelHandler)this.quicChannelInitializer));
        ChannelOperations.addReactiveBridge((Channel)channel, (ChannelOperations.OnSetup)this.opsFactory, (ConnectionObserver)this.obs);
        channel.config().setAutoRead(true);
    }

    static class HttpTrafficHandler
    extends ChannelInboundHandlerAdapter {
        final ConnectionObserver listener;
        final ChannelHandler quicChannelInitializer;

        HttpTrafficHandler(ConnectionObserver listener, ChannelHandler quicChannelInitializer) {
            this.listener = listener;
            this.quicChannelInitializer = quicChannelInitializer;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (ctx.channel().isActive()) {
                Connection c = Connection.from((Channel)ctx.channel());
                this.listener.onStateChange(c, ConnectionObserver.State.CONNECTED);
                this.listener.onStateChange(c, ConnectionObserver.State.CONFIGURED);
            }
        }
    }
}

