/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations.idm;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonIgnore;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.keycloak.org.keycloak.common.util.PemUtils;
import java.security.PublicKey;

public class PublishedRealmRepresentation {
    protected String realm;
    @JsonProperty(value="public_key")
    protected String publicKeyPem;
    @JsonProperty(value="token-service")
    protected String tokenServiceUrl;
    @JsonProperty(value="account-service")
    protected String accountServiceUrl;
    @JsonProperty(value="tokens-not-before")
    protected int notBefore;
    @JsonIgnore
    protected volatile transient PublicKey publicKey;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.publicKeyPem = publicKeyPem;
        this.publicKey = null;
    }

    @JsonIgnore
    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        if (this.publicKeyPem != null) {
            try {
                this.publicKey = PemUtils.decodePublicKey(this.publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    @JsonIgnore
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        this.publicKeyPem = PemUtils.encodeKey(publicKey);
    }

    public String getTokenServiceUrl() {
        return this.tokenServiceUrl;
    }

    public void setTokenServiceUrl(String tokenServiceUrl) {
        this.tokenServiceUrl = tokenServiceUrl;
    }

    public String getAccountServiceUrl() {
        return this.accountServiceUrl;
    }

    public void setAccountServiceUrl(String accountServiceUrl) {
        this.accountServiceUrl = accountServiceUrl;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }
}

