/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class ClaimsRepresentation {
    @JsonProperty(value="id_token")
    private Map<String, ClaimValue> idTokenClaims;
    @JsonProperty(value="userinfo")
    private Map<String, ClaimValue> userinfoClaims;

    public Map<String, ClaimValue> getIdTokenClaims() {
        return this.idTokenClaims;
    }

    public void setIdTokenClaims(Map<String, ClaimValue> idTokenClaims) {
        this.idTokenClaims = idTokenClaims;
    }

    public Map<String, ClaimValue> getUserinfoClaims() {
        return this.userinfoClaims;
    }

    public void setUserinfoClaims(Map<String, ClaimValue> userinfoClaims) {
        this.userinfoClaims = userinfoClaims;
    }

    public boolean isPresent(String claimName, ClaimContext ctx) {
        if (ctx == ClaimContext.ID_TOKEN) {
            return this.idTokenClaims != null && this.idTokenClaims.containsKey(claimName);
        }
        if (ctx == ClaimContext.USERINFO) {
            return this.userinfoClaims != null && this.userinfoClaims.containsKey(claimName);
        }
        throw new IllegalArgumentException("Invalid claim context");
    }

    public boolean isPresentAsNullClaim(String claimName, ClaimContext ctx) {
        if (!this.isPresent(claimName, ctx)) {
            return false;
        }
        if (ctx == ClaimContext.ID_TOKEN) {
            return this.idTokenClaims.get(claimName) == null;
        }
        if (ctx == ClaimContext.USERINFO) {
            return this.userinfoClaims.get(claimName) == null;
        }
        throw new IllegalArgumentException("Invalid claim context");
    }

    public <CLAIM_TYPE> ClaimValue<CLAIM_TYPE> getClaimValue(String claimName, ClaimContext ctx, Class<CLAIM_TYPE> claimType) {
        if (!this.isPresent(claimName, ctx)) {
            return null;
        }
        if (ctx == ClaimContext.ID_TOKEN) {
            return this.idTokenClaims.get(claimName);
        }
        if (ctx == ClaimContext.USERINFO) {
            return this.userinfoClaims.get(claimName);
        }
        throw new IllegalArgumentException("Invalid claim context");
    }

    public static class ClaimValue<CLAIM_TYPE> {
        private Boolean essential;
        private CLAIM_TYPE value;
        private List<CLAIM_TYPE> values;

        public Boolean getEssential() {
            return this.essential;
        }

        public boolean isEssential() {
            return this.essential != null && this.essential != false;
        }

        public void setEssential(Boolean essential) {
            this.essential = essential;
        }

        public CLAIM_TYPE getValue() {
            return this.value;
        }

        public void setValue(CLAIM_TYPE value) {
            this.value = value;
        }

        public List<CLAIM_TYPE> getValues() {
            return this.values;
        }

        public void setValues(List<CLAIM_TYPE> values) {
            this.values = values;
        }
    }

    public static enum ClaimContext {
        ID_TOKEN,
        USERINFO;

    }
}

