/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonAnyGetter;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonAnySetter;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthorizationDetailsJSONRepresentation
implements Serializable {
    public static final String STATIC_SCOPE_RAR_TYPE = "https://keycloak.org/auth-type/static-oauth2-scope";
    public static final String DYNAMIC_SCOPE_RAR_TYPE = "https://keycloak.org/auth-type/dynamic-oauth2-scope";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="locations")
    private List<String> locations;
    @JsonProperty(value="actions")
    private List<String> actions;
    @JsonProperty(value="datatypes")
    private List<String> datatypes;
    @JsonProperty(value="identifier")
    private String identifier;
    @JsonProperty(value="privileges")
    private List<String> privileges;
    private final Map<String, Object> customData = new HashMap<String, Object>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public List<String> getDatatypes() {
        return this.datatypes;
    }

    public void setDatatypes(List<String> datatypes) {
        this.datatypes = datatypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<String> privileges) {
        this.privileges = privileges;
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @JsonAnySetter
    public void setCustomData(String key, Object value) {
        this.customData.put(key, value);
    }

    public String toString() {
        return "AuthorizationDetailsJSONRepresentation{type='" + this.type + '\'' + ", locations=" + this.locations + ", actions=" + this.actions + ", datatypes=" + this.datatypes + ", identifier='" + this.identifier + '\'' + ", privileges=" + this.privileges + ", customData=" + this.customData + '}';
    }

    public String getScopeNameFromCustomData() {
        if (this.getType().equalsIgnoreCase(DYNAMIC_SCOPE_RAR_TYPE) || this.getType().equalsIgnoreCase(STATIC_SCOPE_RAR_TYPE)) {
            List accessList = (List)this.customData.get("access");
            if (accessList.isEmpty()) {
                throw new RuntimeException("A RAR Scope representation should never have an empty access property");
            }
            return (String)accessList.get(0);
        }
        return null;
    }

    public String getDynamicScopeParamFromCustomData() {
        if (this.getType().equalsIgnoreCase(DYNAMIC_SCOPE_RAR_TYPE)) {
            return (String)this.customData.get("scope_parameter");
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationDetailsJSONRepresentation that = (AuthorizationDetailsJSONRepresentation)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.locations, that.locations) && Objects.equals(this.actions, that.actions) && Objects.equals(this.datatypes, that.datatypes) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.privileges, that.privileges) && Objects.equals(this.customData, that.customData);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.locations, this.actions, this.datatypes, this.identifier, this.privileges, this.customData);
    }
}

