/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jws;

import io.pravega.keycloak.org.keycloak.common.util.Base64Url;
import io.pravega.keycloak.org.keycloak.jose.JOSE;
import io.pravega.keycloak.org.keycloak.jose.jws.JWSHeader;
import io.pravega.keycloak.org.keycloak.jose.jws.JWSInputException;
import io.pravega.keycloak.org.keycloak.util.JsonSerialization;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JWSInput
implements JOSE {
    String wireString;
    String encodedHeader;
    String encodedContent;
    String encodedSignature;
    String encodedSignatureInput;
    JWSHeader header;
    byte[] content;
    byte[] signature;

    public JWSInput(String wire) throws JWSInputException {
        try {
            this.wireString = wire;
            String[] parts = wire.split("\\.");
            if (parts.length < 2 || parts.length > 3) {
                throw new IllegalArgumentException("Parsing error");
            }
            this.encodedHeader = parts[0];
            this.encodedContent = parts[1];
            this.encodedSignatureInput = this.encodedHeader + '.' + this.encodedContent;
            this.content = Base64Url.decode(this.encodedContent);
            if (parts.length > 2) {
                this.encodedSignature = parts[2];
                this.signature = Base64Url.decode(this.encodedSignature);
            }
            byte[] headerBytes = Base64Url.decode(this.encodedHeader);
            this.header = JsonSerialization.readValue(headerBytes, JWSHeader.class);
        }
        catch (Throwable t) {
            throw new JWSInputException(t);
        }
    }

    public String getWireString() {
        return this.wireString;
    }

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public String getEncodedContent() {
        return this.encodedContent;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getEncodedSignatureInput() {
        return this.encodedSignatureInput;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public <T> T readJsonContent(Class<T> type) throws JWSInputException {
        try {
            return JsonSerialization.readValue(this.content, type);
        }
        catch (IOException e) {
            throw new JWSInputException(e);
        }
    }

    public String readContentAsString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }
}

