/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwe;

import io.pravega.keycloak.org.keycloak.common.crypto.CryptoIntegration;
import io.pravega.keycloak.org.keycloak.jose.jwe.alg.DirectAlgorithmProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.alg.RsaKeyEncryption256JWEAlgorithmProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.alg.RsaKeyEncryptionJWEAlgorithmProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.AesCbcHmacShaEncryptionProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.AesGcmJWEEncryptionProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import java.util.HashMap;
import java.util.Map;

class JWERegistry {
    private static final Map<String, JWEEncryptionProvider> ENC_PROVIDERS = new HashMap<String, JWEEncryptionProvider>();
    private static final Map<String, JWEAlgorithmProvider> ALG_PROVIDERS = new HashMap<String, JWEAlgorithmProvider>();

    JWERegistry() {
    }

    static JWEAlgorithmProvider getAlgProvider(String alg) {
        return ALG_PROVIDERS.get(alg);
    }

    static JWEEncryptionProvider getEncProvider(String enc) {
        return ENC_PROVIDERS.get(enc);
    }

    static {
        ALG_PROVIDERS.put("dir", new DirectAlgorithmProvider());
        ALG_PROVIDERS.put("A128KW", CryptoIntegration.getProvider().getAlgorithmProvider(JWEAlgorithmProvider.class, "aes-keywrap-alg"));
        ALG_PROVIDERS.put("RSA-OAEP", new RsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"));
        ALG_PROVIDERS.put("RSA-OAEP-256", new RsaKeyEncryption256JWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-256AndMGF1Padding"));
        ENC_PROVIDERS.put("A256GCM", new AesGcmJWEEncryptionProvider("A256GCM"));
        ENC_PROVIDERS.put("A128CBC-HS256", new AesCbcHmacShaEncryptionProvider.Aes128CbcHmacSha256Provider());
        ENC_PROVIDERS.put("A192CBC-HS384", new AesCbcHmacShaEncryptionProvider.Aes192CbcHmacSha384Provider());
        ENC_PROVIDERS.put("A256CBC-HS512", new AesCbcHmacShaEncryptionProvider.Aes256CbcHmacSha512Provider());
    }
}

