/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose;

import io.pravega.keycloak.com.fasterxml.jackson.databind.JsonNode;
import io.pravega.keycloak.org.keycloak.common.util.Base64Url;
import io.pravega.keycloak.org.keycloak.jose.JOSE;
import io.pravega.keycloak.org.keycloak.jose.jwe.JWE;
import io.pravega.keycloak.org.keycloak.jose.jws.JWSInput;
import io.pravega.keycloak.org.keycloak.jose.jws.JWSInputException;
import io.pravega.keycloak.org.keycloak.util.JsonSerialization;
import java.io.IOException;

public class JOSEParser {
    public static JOSE parse(String jwt) {
        JsonNode header;
        String[] parts = jwt.split("\\.");
        if (parts.length == 0) {
            throw new RuntimeException("Could not infer header from JWT");
        }
        try {
            header = JsonSerialization.readValue(Base64Url.decode(parts[0]), JsonNode.class);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to parse JWT header", cause);
        }
        if (header.has("enc")) {
            return new JWE(jwt);
        }
        try {
            return new JWSInput(jwt);
        }
        catch (JWSInputException cause) {
            throw new RuntimeException("Failed to build JWS", cause);
        }
    }
}

