/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.crypto;

import io.pravega.keycloak.org.keycloak.common.VerificationException;
import io.pravega.keycloak.org.keycloak.crypto.JavaAlgorithm;
import io.pravega.keycloak.org.keycloak.crypto.KeyWrapper;
import io.pravega.keycloak.org.keycloak.crypto.SignatureVerifierContext;
import java.security.PublicKey;
import java.security.Signature;

public class AsymmetricSignatureVerifierContext
implements SignatureVerifierContext {
    private final KeyWrapper key;

    public AsymmetricSignatureVerifierContext(KeyWrapper key) {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithmOrDefault();
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        try {
            Signature verifier = Signature.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithmOrDefault()));
            verifier.initVerify((PublicKey)this.key.getPublicKey());
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (Exception e) {
            throw new VerificationException("Signing failed", e);
        }
    }
}

