/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util.reflections;

import io.pravega.keycloak.org.keycloak.common.util.reflections.SetAccessiblePrivilegedAction;
import io.pravega.keycloak.org.keycloak.common.util.reflections.Types;
import io.pravega.keycloak.org.keycloak.common.util.reflections.UnSetAccessiblePrivilegedAction;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Reflections {
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Type[] EMPTY_TYPES = new Type[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];

    private Reflections() {
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field a : c.getDeclaredFields()) {
                fields.add(a);
            }
        }
        return fields;
    }

    public static Field findDeclaredField(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Set<Annotation> getAnnotationsWithMetaAnnotation(Set<Annotation> annotations, Class<? extends Annotation> metaAnnotationType) {
        HashSet<Annotation> set = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            set.add(annotation);
        }
        return set;
    }

    public static boolean methodExists(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m3 : c.getDeclaredMethods()) {
                if (!m3.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method a : c.getDeclaredMethods()) {
                methods.add(a);
            }
        }
        return methods;
    }

    public static Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... args) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Constructor<?> findDeclaredConstructor(Class<?> clazz, Class<?> ... args) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredConstructor(args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Set<Constructor<?>> getAllDeclaredConstructors(Class<?> clazz) {
        HashSet constructors = new HashSet();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Constructor<?> constructor : c.getDeclaredConstructors()) {
                constructors.add(constructor);
            }
        }
        return constructors;
    }

    public static Class<?> getMemberType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getDeclaringClass();
        }
        throw new UnsupportedOperationException("Cannot operate on a member of type " + member.getClass());
    }

    public static <T> Class<T> classForName(String name, ClassLoader ... loaders) throws ClassNotFoundException {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            for (ClassLoader l : loaders) {
                try {
                    return Class.forName(name, true, l);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (Thread.currentThread().getContextClassLoader() != null) {
                throw new ClassNotFoundException("Could not load class " + name + " with the context class loader " + Thread.currentThread().getContextClassLoader().toString() + " or any of the additional ClassLoaders: " + Arrays.toString(loaders));
            }
            throw new ClassNotFoundException("Could not load class " + name + " using Class.forName or using any of the additional ClassLoaders: " + Arrays.toString(loaders));
        }
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append((i > 0 ? "," : "") + args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    public static Object invokeMethod(Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(false, method, Object.class, instance, args);
    }

    public static Object invokeMethod(boolean setAccessible, Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(setAccessible, method, Object.class, instance, args);
    }

    public static <T> T invokeMethod(Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        return Reflections.invokeMethod(false, method, expectedReturnType, instance, args);
    }

    public static <T> T invokeMethod(boolean setAccessible, Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        if (setAccessible && !method.isAccessible()) {
            Reflections.setAccessible(method);
        }
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex.getCause());
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static <A extends AccessibleObject> A setAccessible(A member) {
        AccessController.doPrivileged(new SetAccessiblePrivilegedAction(member));
        return member;
    }

    public static <A extends AccessibleObject> A unsetAccessible(A member) {
        AccessController.doPrivileged(new UnSetAccessiblePrivilegedAction(member));
        return member;
    }

    private static String buildSetFieldValueErrorMessage(Field field, Object obj, Object value) {
        return String.format("Exception setting [%s] field on object [%s] to value [%s]", field.getName(), obj, value);
    }

    private static String buildGetFieldValueErrorMessage(Field field, Object obj) {
        return String.format("Exception reading [%s] field from object [%s].", field.getName(), obj);
    }

    public static Object getFieldValue(Field field, Object instance) {
        return Reflections.getFieldValue(field, instance, Object.class);
    }

    public static <T> T getFieldValue(Field field, Object instance, Class<T> expectedType) {
        try {
            return Reflections.cast(field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildGetFieldValueErrorMessage(field, instance), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildGetFieldValueErrorMessage(field, instance));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildGetFieldValueErrorMessage(field, instance));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static Map<Class<?>, Type> buildTypeMap(Set<Type> types) {
        HashMap map = new HashMap();
        for (Type type : types) {
            if (type instanceof Class) {
                map.put((Class)type, type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                if (!(((ParameterizedType)type).getRawType() instanceof Class)) continue;
                map.put((Class)((ParameterizedType)type).getRawType(), type);
                continue;
            }
            if (!(type instanceof TypeVariable)) continue;
        }
        return map;
    }

    public static boolean isCacheable(Set<Annotation> annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (!clazz.isAnonymousClass() && (!clazz.isMemberClass() || !Reflections.isStatic(clazz))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCacheable(Annotation[] annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (!clazz.isAnonymousClass() && (!clazz.isMemberClass() || !Reflections.isStatic(clazz))) continue;
            return false;
        }
        return true;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static int getNesting(Class<?> clazz) {
        if (clazz.isMemberClass() && !Reflections.isStatic(clazz)) {
            return 1 + Reflections.getNesting(clazz.getDeclaringClass());
        }
        return 0;
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type) {
        return Reflections.getNonPrivateFinalMethodOrType(type) != null;
    }

    public static Object getNonPrivateFinalMethodOrType(Class<?> type) {
        if (Reflections.isFinal(type)) {
            return type;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!Reflections.isFinal(method) || Reflections.isPrivate(method)) continue;
            return method;
        }
        return null;
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isParamerterizedTypeWithWildcard(Class<?> type) {
        if (Reflections.isParameterizedType(type)) {
            return Reflections.containsWildcards(type.getTypeParameters());
        }
        return false;
    }

    public static boolean containsWildcards(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).isAssignableFrom(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).equals(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean isAssignableFrom(Type[] actualTypeArguments1, Type[] actualTypeArguments2) {
        for (int i = 0; i < actualTypeArguments1.length; ++i) {
            Type type1 = actualTypeArguments1[i];
            Object type2 = Object.class;
            if (actualTypeArguments2.length > i) {
                type2 = actualTypeArguments2[i];
            }
            if (Reflections.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableFrom(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.isAssignableFrom(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.matches(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!Reflections.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.isAssignableFrom(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.isAssignableFrom((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean matches(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.matches(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.matches((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean isTypeBounded(Type type, Type[] lowerBounds, Type[] upperBounds) {
        if (lowerBounds.length > 0 && !Reflections.isAssignableFrom(type, lowerBounds)) {
            return false;
        }
        return upperBounds.length <= 0 || Reflections.isAssignableFrom(upperBounds, type);
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        TypeVariable typeVariable;
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.isAssignableFrom(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : (type2 instanceof Class ? Reflections.isAssignableFrom(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES) : type2 instanceof TypeVariable && Reflections.isTypeBounded(rawType1, actualTypeArguments1, (typeVariable = (TypeVariable)type2).getBounds()));
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.matches(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : type2 instanceof Class && Reflections.matches(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES);
    }

    public static boolean isAssignableFrom(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.matches(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Set<Type> types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Type type) {
        Class rawType = Reflections.getRawType(type);
        return rawType == null ? false : rawType.isPrimitive();
    }

    public static <T> T newInstance(Class<T> fromClass) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return Reflections.newInstance(fromClass, fromClass.getName());
    }

    public static <T> T newInstance(Class<?> type, String fullQualifiedName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return Reflections.classForName(fullQualifiedName, type.getClassLoader()).newInstance();
    }

    public static Class<?> resolveListType(Field field, Object instance) throws IllegalAccessException {
        List item;
        if (!List.class.isAssignableFrom(field.getType())) {
            return null;
        }
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments();
            if (typeArguments[0] instanceof Class) {
                return (Class)typeArguments[0];
            }
        } else if (instance != null && !(item = (List)List.class.cast(field.get(instance))).isEmpty()) {
            return item.get(0).getClass();
        }
        return Object.class;
    }
}

