/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class SystemEnvProperties
extends Properties {
    private final Map<String, String> overrides;

    public SystemEnvProperties(Map<String, String> overrides) {
        this.overrides = overrides;
    }

    public SystemEnvProperties() {
        this.overrides = Collections.EMPTY_MAP;
    }

    @Override
    public String getProperty(String key) {
        if (this.overrides.containsKey(key)) {
            return this.overrides.get(key);
        }
        if (key.startsWith("env.")) {
            return System.getenv().get(key.substring(4));
        }
        return System.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }
}

