/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util;

import io.pravega.keycloak.org.jboss.logging.Logger;
import io.pravega.keycloak.org.keycloak.common.crypto.CryptoIntegration;
import java.security.Provider;
import java.security.Security;

public class BouncyIntegration {
    private static final Logger log = Logger.getLogger(BouncyIntegration.class);
    public static final String PROVIDER = BouncyIntegration.loadProvider();

    private static String loadProvider() {
        Provider provider = CryptoIntegration.getProvider().getAlgorithmProvider(Provider.class, "bc-provider");
        if (provider == null) {
            throw new RuntimeException("Failed to load required security provider: BouncyCastleProvider or BouncyCastleFipsProvider");
        }
        if (Security.getProvider(provider.getName()) == null) {
            Security.addProvider(provider);
            log.debugv("Loaded {0} security provider", (Object)provider.getClass().getName());
        } else {
            log.debugv("Security provider {0} already loaded", (Object)provider.getClass().getName());
        }
        return provider.getName();
    }
}

