/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.authorization.client.util;

import io.pravega.keycloak.org.keycloak.authorization.client.AuthorizationDeniedException;
import io.pravega.keycloak.org.keycloak.authorization.client.representation.TokenIntrospectionResponse;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpResponseException;
import io.pravega.keycloak.org.keycloak.authorization.client.util.TokenCallable;
import java.util.concurrent.Callable;

public final class Throwables {
    public static RuntimeException handleWrapException(String message, Throwable cause) {
        if (cause instanceof HttpResponseException) {
            throw Throwables.handleAndWrapHttpResponseException((HttpResponseException)HttpResponseException.class.cast(cause));
        }
        return new RuntimeException(message, cause);
    }

    public static <V> V retryAndWrapExceptionIfNecessary(Callable<V> callable, TokenCallable token, String message, Throwable cause) throws RuntimeException {
        HttpResponseException httpe;
        if (token == null || !token.isRetry()) {
            throw Throwables.handleWrapException(message, cause);
        }
        if (cause instanceof HttpResponseException && (httpe = (HttpResponseException)HttpResponseException.class.cast(cause)).getStatusCode() == 403) {
            TokenIntrospectionResponse response = token.getHttp().post(token.getServerConfiguration().getIntrospectionEndpoint()).authentication().client().param("token", token.call()).response().json(TokenIntrospectionResponse.class).execute();
            if (!response.getActive().booleanValue()) {
                token.clearTokens();
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw Throwables.handleWrapException(message, e);
                }
            }
            throw Throwables.handleWrapException(message, cause);
        }
        throw new RuntimeException(message, cause);
    }

    private static RuntimeException handleAndWrapHttpResponseException(HttpResponseException exception) {
        if (403 == exception.getStatusCode()) {
            throw new AuthorizationDeniedException(exception);
        }
        return new RuntimeException(exception);
    }
}

