/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.authorization.client.util;

import io.pravega.keycloak.org.apache.http.Header;
import io.pravega.keycloak.org.keycloak.authorization.client.ClientAuthenticator;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpMethod;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.AuthorizationRequest;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.Permission;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.PermissionTicketToken;
import java.util.Arrays;
import java.util.Set;

public class HttpMethodAuthenticator<R> {
    private final HttpMethod<R> method;
    private final ClientAuthenticator authenticator;

    public HttpMethodAuthenticator(HttpMethod<R> method, ClientAuthenticator authenticator) {
        this.method = method;
        this.authenticator = authenticator;
    }

    public HttpMethod<R> client() {
        this.method.params.put("grant_type", Arrays.asList("client_credentials"));
        this.authenticator.configureClientCredentials(this.method.params, this.method.headers);
        return this.method;
    }

    public HttpMethod<R> oauth2ResourceOwnerPassword(String userName, String password) {
        return this.oauth2ResourceOwnerPassword(userName, password, null);
    }

    public HttpMethod<R> oauth2ResourceOwnerPassword(String userName, String password, String scope) {
        this.client();
        this.method.params.put("grant_type", Arrays.asList("password"));
        this.method.params.put("username", Arrays.asList(userName));
        this.method.params.put("password", Arrays.asList(password));
        if (scope != null) {
            this.method.params.put("scope", Arrays.asList(scope));
        }
        return this.method;
    }

    public HttpMethod<R> uma() {
        Header authorizationHeader = this.method.builder.getFirstHeader("Authorization");
        if (authorizationHeader == null || !authorizationHeader.getValue().toLowerCase().startsWith("bearer")) {
            this.client();
        }
        this.method.params.put("grant_type", Arrays.asList("urn:ietf:params:oauth:grant-type:uma-ticket"));
        return this.method;
    }

    public HttpMethod<R> uma(AuthorizationRequest request) {
        AuthorizationRequest.Metadata metadata;
        String ticket = request.getTicket();
        PermissionTicketToken permissions = request.getPermissions();
        if (ticket == null && permissions == null) {
            throw new IllegalArgumentException("You must either provide a permission ticket or the permissions you want to request.");
        }
        this.uma();
        this.method.param("ticket", ticket);
        this.method.param("claim_token", request.getClaimToken());
        this.method.param("claim_token_format", request.getClaimTokenFormat());
        this.method.param("pct", request.getPct());
        this.method.param("rpt", request.getRptToken());
        this.method.param("scope", request.getScope());
        this.method.param("audience", request.getAudience());
        this.method.param("subject_token", request.getSubjectToken());
        if (permissions != null) {
            for (Permission permission : permissions.getPermissions()) {
                String resourceId = permission.getResourceId();
                Set<String> scopes = permission.getScopes();
                StringBuilder value = new StringBuilder();
                if (resourceId != null) {
                    value.append(resourceId);
                }
                if (scopes != null && !scopes.isEmpty()) {
                    value.append("#");
                    for (String scope : scopes) {
                        if (!value.toString().endsWith("#")) {
                            value.append(",");
                        }
                        value.append(scope);
                    }
                }
                this.method.params("permission", value.toString());
            }
        }
        if ((metadata = request.getMetadata()) != null) {
            if (metadata.getIncludeResourceName() != null) {
                this.method.param("response_include_resource_name", metadata.getIncludeResourceName().toString());
            }
            if (metadata.getLimit() != null) {
                this.method.param("response_permissions_limit", metadata.getLimit().toString());
            }
        }
        return this.method;
    }
}

