/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.authorization.client.resource;

import io.pravega.keycloak.org.keycloak.authorization.client.AuthorizationDeniedException;
import io.pravega.keycloak.org.keycloak.authorization.client.Configuration;
import io.pravega.keycloak.org.keycloak.authorization.client.representation.ServerConfiguration;
import io.pravega.keycloak.org.keycloak.authorization.client.util.Http;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpMethod;
import io.pravega.keycloak.org.keycloak.authorization.client.util.Throwables;
import io.pravega.keycloak.org.keycloak.authorization.client.util.TokenCallable;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.AuthorizationRequest;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.AuthorizationResponse;
import java.util.concurrent.Callable;

public class AuthorizationResource {
    private Configuration configuration;
    private ServerConfiguration serverConfiguration;
    private Http http;
    private TokenCallable token;

    public AuthorizationResource(Configuration configuration, ServerConfiguration serverConfiguration, Http http, TokenCallable token) {
        this.configuration = configuration;
        this.serverConfiguration = serverConfiguration;
        this.http = http;
        this.token = token;
    }

    public AuthorizationResponse authorize() throws AuthorizationDeniedException {
        return this.authorize(new AuthorizationRequest());
    }

    public AuthorizationResponse authorize(final AuthorizationRequest request) throws AuthorizationDeniedException {
        if (request == null) {
            throw new IllegalArgumentException("Authorization request must not be null");
        }
        Callable<AuthorizationResponse> callable = new Callable<AuthorizationResponse>(){

            @Override
            public AuthorizationResponse call() throws Exception {
                if (request.getAudience() == null) {
                    request.setAudience(AuthorizationResource.this.configuration.getResource());
                }
                HttpMethod method = AuthorizationResource.this.http.post(AuthorizationResource.this.serverConfiguration.getTokenEndpoint());
                if (AuthorizationResource.this.token != null) {
                    method = method.authorizationBearer(AuthorizationResource.this.token.call());
                }
                return method.authentication().uma(request).response().json(AuthorizationResponse.class).execute();
            }
        };
        try {
            return (AuthorizationResponse)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.token, "Failed to obtain authorization data", cause);
        }
    }
}

