/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak;

import io.pravega.keycloak.org.keycloak.representations.AccessToken;
import io.pravega.keycloak.org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AuthorizationContext {
    private final AccessToken authzToken;
    private final PolicyEnforcerConfig.PathConfig current;
    private boolean granted;

    public AuthorizationContext(AccessToken authzToken, PolicyEnforcerConfig.PathConfig current) {
        this.authzToken = authzToken;
        this.current = current;
        this.granted = true;
    }

    public AuthorizationContext() {
        this(null, null);
        this.granted = false;
    }

    public boolean hasPermission(String resourceName, String scopeName) {
        if (this.authzToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        for (Permission permission : authorization.getPermissions()) {
            if (!resourceName.equalsIgnoreCase(permission.getResourceName()) && !resourceName.equalsIgnoreCase(permission.getResourceId())) continue;
            if (scopeName == null) {
                return true;
            }
            if (!permission.getScopes().contains(scopeName)) continue;
            return true;
        }
        return this.current != null && scopeName == null && this.current.getName().equals(resourceName);
    }

    public boolean hasResourcePermission(String resourceName) {
        return this.hasPermission(resourceName, null);
    }

    public boolean hasScopePermission(String scopeName) {
        if (this.authzToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        for (Permission permission : authorization.getPermissions()) {
            if (!permission.getScopes().contains(scopeName)) continue;
            return true;
        }
        return false;
    }

    public List<Permission> getPermissions() {
        if (this.authzToken == null) {
            return Collections.emptyList();
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<Permission>(authorization.getPermissions()));
    }

    public boolean isGranted() {
        return this.granted;
    }
}

