/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak;

import io.pravega.keycloak.org.keycloak.common.enums.RelativeUrlsUsed;
import io.pravega.keycloak.org.keycloak.common.util.KeycloakUriBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class AbstractOAuthClient {
    private static final String OAUTH_TOKEN_REQUEST_STATE = "OAuth_Token_Request_State";
    private final AtomicLong counter = new AtomicLong();
    protected String clientId;
    protected Map<String, Object> credentials;
    protected String authUrl;
    protected String tokenUrl;
    protected RelativeUrlsUsed relativeUrlsUsed;
    protected String scope;
    protected String stateCookieName = "OAuth_Token_Request_State";
    protected String stateCookiePath;
    protected boolean isSecure;
    protected boolean publicClient;

    protected String getStateCode() {
        return this.counter.getAndIncrement() + "/" + UUID.randomUUID().toString();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, Object> credentials) {
        this.credentials = credentials;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getStateCookieName() {
        return this.stateCookieName;
    }

    public void setStateCookieName(String stateCookieName) {
        this.stateCookieName = stateCookieName;
    }

    public String getStateCookiePath() {
        return this.stateCookiePath;
    }

    public void setStateCookiePath(String stateCookiePath) {
        this.stateCookiePath = stateCookiePath;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    public RelativeUrlsUsed getRelativeUrlsUsed() {
        return this.relativeUrlsUsed;
    }

    public void setRelativeUrlsUsed(RelativeUrlsUsed relativeUrlsUsed) {
        this.relativeUrlsUsed = relativeUrlsUsed;
    }

    protected String stripOauthParametersFromRedirect(String uri) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri(uri).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.buildAsString(new Object[0]);
    }
}

