/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.apache.http.protocol;

import io.pravega.keycloak.org.apache.http.HttpException;
import io.pravega.keycloak.org.apache.http.HttpRequest;
import io.pravega.keycloak.org.apache.http.HttpRequestInterceptor;
import io.pravega.keycloak.org.apache.http.annotation.Contract;
import io.pravega.keycloak.org.apache.http.annotation.ThreadingBehavior;
import io.pravega.keycloak.org.apache.http.protocol.HttpContext;
import io.pravega.keycloak.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

