/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.hystrix;

import io.pivotal.spring.cloud.config.java.ServiceInfoPropertySourceAdapter;
import io.pivotal.spring.cloud.service.common.HystrixAmqpServiceInfo;
import java.util.LinkedHashMap;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
public class HystrixStreamServiceConnector
extends ServiceInfoPropertySourceAdapter<HystrixAmqpServiceInfo> {
    public static final String PROPERTY_SOURCE_NAME = "springCloudServicesCircuitBreaker";
    public static final String SPRING_CLOUD_HYSTRIX_STREAM = "spring.cloud.hystrix.stream";
    public static final String SPRING_CLOUD_STREAM = "spring.cloud.stream.";
    public static final String SPRING_CLOUD_STREAM_BINDINGS_HYSTRIXSTREAMOUTPUT = "spring.cloud.stream.bindings.hystrixStreamOutput.";
    public static final String SPRING_CLOUD_STREAM_BINDERS_HYSTRIX = "spring.cloud.stream.binders.hystrix.";
    public static final String SPRING_CLOUD_STREAM_BINDERS_HYSTRIX_ENVIRONMENT_SPRING_RABBITMQ = "spring.cloud.stream.binders.hystrix.environment.spring.rabbitmq.";

    @Override
    protected PropertySource<?> toPropertySource(HystrixAmqpServiceInfo serviceInfo) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("spring.cloud.stream.bindings.hystrixStreamOutput.destination", SPRING_CLOUD_HYSTRIX_STREAM);
        properties.put("spring.cloud.stream.bindings.hystrixStreamOutput.binder", "hystrix");
        properties.put("spring.cloud.stream.binders.hystrix.type", "rabbit");
        properties.put("spring.cloud.stream.binders.hystrix.inheritEnvironment", false);
        properties.put("spring.cloud.stream.binders.hystrix.defaultCandidate", false);
        properties.put("spring.cloud.stream.binders.hystrix.environment.spring.cloud.stream.overrideCloudConnectors", true);
        properties.put("spring.cloud.stream.binders.hystrix.environment.spring.rabbitmq.addresses", serviceInfo.getAddresses());
        properties.put("spring.cloud.stream.binders.hystrix.environment.spring.rabbitmq.username", serviceInfo.getUserName());
        properties.put("spring.cloud.stream.binders.hystrix.environment.spring.rabbitmq.password", serviceInfo.getPassword());
        properties.put("spring.cloud.stream.binders.hystrix.environment.spring.rabbitmq.virtualHost", serviceInfo.getVirtualHost());
        properties.put("spring.cloud.stream.binders.hystrix.environment.spring.rabbitmq.ssl.enabled", serviceInfo.getSslEnabled());
        properties.put("spring.cloud.stream.binders.hystrix.default.prefix", "");
        return new MapPropertySource(PROPERTY_SOURCE_NAME, properties);
    }
}

