/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.pivotal.cfenv.core.CfApplication;
import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CfEnv {
    public static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    public static final String VCAP_SERVICES = "VCAP_SERVICES";
    private ObjectMapper objectMapper = new ObjectMapper();
    private List<CfService> cfServices = new ArrayList<CfService>();
    private CfApplication cfApplication;

    public CfEnv() {
        try {
            String vcapServicesJson = System.getenv(VCAP_SERVICES);
            if (vcapServicesJson != null && vcapServicesJson.length() > 0) {
                Map rawServices = (Map)this.objectMapper.readValue(vcapServicesJson, (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(){});
                for (Map.Entry entry : rawServices.entrySet()) {
                    for (Map serviceData : (List)entry.getValue()) {
                        this.cfServices.add(new CfService(serviceData));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access/parse VCAP_SERVICES environment variable.", e);
        }
        try {
            String vcapApplicationJson = System.getenv(VCAP_APPLICATION);
            if (vcapApplicationJson != null && vcapApplicationJson.length() > 0) {
                Map applicationData = (Map)this.objectMapper.readValue(vcapApplicationJson, Map.class);
                this.cfApplication = new CfApplication(applicationData);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access/parse VCAP_APPLICATIONenvironment variable.", e);
        }
    }

    public CfApplication getApp() {
        return this.cfApplication;
    }

    public List<CfService> findAllServices() {
        return this.cfServices;
    }

    public List<CfService> findServicesByName(String ... spec) {
        ArrayList<CfService> cfServices = new ArrayList<CfService>();
        for (CfService cfService : this.cfServices) {
            if (spec == null) continue;
            for (String regex : spec) {
                String name = cfService.getName();
                if (name == null || name.length() <= 0 || !name.matches(regex)) continue;
                cfServices.add(cfService);
            }
        }
        return cfServices;
    }

    public CfService findServiceByName(String ... spec) {
        List<CfService> cfServices = this.findServicesByName(spec);
        if (cfServices.size() == 1) {
            return (CfService)cfServices.stream().findFirst().get();
        }
        String specMessage = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatches(cfServices, specMessage, "name");
        throw new IllegalArgumentException("No service with name [" + specMessage + "] was found.");
    }

    private void throwExceptionIfMultipleMatches(List<CfService> cfServices, String specMessage, String operation) {
        if (cfServices.size() > 1) {
            CharSequence[] names = (String[])cfServices.stream().map(CfService::getName).toArray(String[]::new);
            throw new IllegalArgumentException("No unique service matching by " + operation + " [" + specMessage + "] was found.  Matching service names are [" + String.join((CharSequence)", ", names) + "]");
        }
    }

    public List<CfService> findServicesByLabel(String ... spec) {
        ArrayList<CfService> cfServices = new ArrayList<CfService>();
        for (CfService cfService : this.cfServices) {
            if (spec == null) continue;
            for (String regex : spec) {
                String name = cfService.getLabel();
                if (name == null || name.length() <= 0 || !name.matches(regex)) continue;
                cfServices.add(cfService);
            }
        }
        return cfServices;
    }

    public CfService findServiceByLabel(String ... spec) {
        List<CfService> cfServices = this.findServicesByLabel(spec);
        if (cfServices.size() == 1) {
            return (CfService)cfServices.stream().findFirst().get();
        }
        String message = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatches(cfServices, message, "label");
        throw new IllegalArgumentException("No service with label [" + message + "] was found.");
    }

    public CfService findServiceByTag(String ... spec) {
        List<CfService> cfServices = this.findServicesByTag(spec);
        if (cfServices.size() == 1) {
            return (CfService)cfServices.stream().findFirst().get();
        }
        String message = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatches(cfServices, message, "tag");
        throw new IllegalArgumentException("No service with tag [" + message + "] was found.");
    }

    public List<CfService> findServicesByTag(String ... spec) {
        ArrayList<CfService> cfServices = new ArrayList<CfService>();
        for (CfService cfService : this.cfServices) {
            if (spec == null) continue;
            for (String regex : spec) {
                List<String> tags = cfService.getTags();
                for (String tag : tags) {
                    if (tag == null || tag.length() <= 0 || !tag.matches(regex)) continue;
                    cfServices.add(cfService);
                }
            }
        }
        return cfServices;
    }

    public CfCredentials findCredentialsByName(String ... spec) {
        CfService cfService = this.findServiceByName(spec);
        return cfService.getCredentials();
    }

    public CfCredentials findCredentialsByLabel(String ... spec) {
        CfService cfService = this.findServiceByLabel(spec);
        return cfService.getCredentials();
    }

    public CfCredentials findCredentialsByTag(String ... spec) {
        CfService cfService = this.findServiceByTag(spec);
        return cfService.getCredentials();
    }

    public boolean isInCf() {
        return System.getenv(VCAP_APPLICATION) != null;
    }
}

