/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import io.pivotal.cfenv.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CfCredentials {
    private final Map<String, Object> credentailsData;
    private UriInfo uriInfo;
    private Map<String, String> derivedCredentials = new HashMap<String, String>();

    public CfCredentials(Map<String, Object> credentailsData) {
        this.credentailsData = credentailsData;
    }

    private synchronized UriInfo createOrGetUriInfo() {
        try {
            if (this.uriInfo == null && (this.credentailsData.containsKey("uri") || this.credentailsData.containsKey("url"))) {
                this.uriInfo = new UriInfo(this.getString("uri", "url"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.uriInfo;
    }

    public Map<String, Object> getMap() {
        return this.credentailsData;
    }

    public Map<String, String> getDerivedCredentials() {
        return this.derivedCredentials;
    }

    public String getHost() {
        String host = this.getString("host", "hostname");
        if (host != null) {
            return host;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? uriInfo.getHost() : null;
    }

    public String getPort() {
        String port = this.getString("port");
        if (port != null) {
            return port;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? String.valueOf(uriInfo.getPort()) : null;
    }

    public String getName() {
        return this.getString("name");
    }

    public String getUsername() {
        String username = this.getString("username", "user");
        if (username != null) {
            return username;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? uriInfo.getUsername() : null;
    }

    public String getPassword() {
        String password = this.getString("password");
        if (password != null) {
            return password;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? uriInfo.getPassword() : null;
    }

    public String getUri(String ... uriSchemes) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(Arrays.asList("uri", "url"));
        for (String uriScheme : uriSchemes) {
            keys.add(uriScheme + "Uri");
            keys.add(uriScheme + "uri");
            keys.add(uriScheme + "Url");
            keys.add(uriScheme + "url");
        }
        return this.getString(keys.toArray(new String[keys.size()]));
    }

    public UriInfo getUriInfo() {
        return this.createOrGetUriInfo();
    }

    public UriInfo getUriInfo(String uriScheme) {
        UriInfo uriInfo;
        String uri = this.getUri(uriScheme);
        if (uri == null) {
            String hostname = this.getHost();
            String port = this.getPort();
            String username = this.getUsername();
            String password = this.getPassword();
            String databaseName = this.getName();
            uriInfo = new UriInfo(uriScheme, hostname, Integer.valueOf(port), username, password, databaseName);
        } else {
            uriInfo = new UriInfo(uri);
        }
        return uriInfo;
    }

    public String getString(String ... keys) {
        if (this.credentailsData != null) {
            for (String key : keys) {
                if (!this.credentailsData.containsKey(key)) continue;
                return this.credentailsData.get(key).toString();
            }
        }
        return null;
    }
}

