/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class PostgresqlJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String POSTGRESQL_SCHEME = "postgres";
    public static final String POSTGRES_JDBC_SCHEME = "postgresql";
    public static final String POSTGRESQL_TAG = "postgresql";
    public static final String POSTGRES_JDBC_TAG = "postgres";
    public static final String POSTGRESQL_LABEL = "postgresql";

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "postgres", "postgresql") || cfService.existsByTagIgnoreCase(new String[]{"postgresql", "postgres"}) || cfService.existsByLabelStartsWith("postgresql") || cfService.existsByUriSchemeStartsWith(new String[]{"postgres", "postgresql"}) || cfService.existsByCredentialsContainsUriField(new String[]{"postgres", "postgresql"});
    }

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("postgresql");
        return String.format("%s%s://%s%s/%s%s%s", "jdbc:", "postgresql", uriInfo.getHost(), uriInfo.formatPort(), uriInfo.getPath(), uriInfo.formatUserNameAndPasswordQuery(), uriInfo.formatQuery());
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }
}

