/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SqlServerJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String SQLSERVER_SCHEME = "sqlserver";
    public static final String SQLSERVER_LABEL = "sqlserver";

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("sqlserver");
        Map<String, String> uriParameters = this.parseSqlServerUriParameters(uriInfo.getUriString());
        String databaseName = this.getDatabaseName(uriParameters);
        try {
            URI uri = new URI(uriInfo.getUriString().substring(0, uriInfo.getUriString().indexOf(";")));
            return String.format("jdbc:%s://%s%s%s%s%s%s", "sqlserver", uri.getHost(), uri.getPort() > 0 ? ":" + uri.getPort() : "", uri.getPath() != null && !uri.getPath().isEmpty() ? "/" + uri.getPath() : "", databaseName != null ? ";database=" + UriInfo.urlEncode((String)databaseName) : "", uriParameters.containsKey("user") ? ";user=" + UriInfo.urlEncode((String)uriParameters.get("user")) : "", uriParameters.containsKey("password") ? ";password=" + UriInfo.urlEncode((String)uriParameters.get("password")) : "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDatabaseName(Map<String, String> uriParameters) {
        String databaseName = null;
        if (uriParameters.containsKey("databaseName")) {
            databaseName = uriParameters.get("databaseName");
        } else if (uriParameters.containsKey("database")) {
            databaseName = uriParameters.get("database");
        }
        return databaseName;
    }

    private Map<String, String> parseSqlServerUriParameters(String uriString) {
        return Arrays.stream(uriString.split(";")).filter(s -> s.contains("=")).map(s -> s.split("=")).filter(t -> ((String[])t).length == 2).collect(Collectors.toMap(this.parameterName(), this.parameterValue(), this.takeFirst()));
    }

    private BinaryOperator<String> takeFirst() {
        return (s, s2) -> s;
    }

    private Function<String[], String> parameterValue() {
        return t -> UriInfo.urlDecode((String)t[1]);
    }

    private Function<String[], String> parameterName() {
        return t -> UriInfo.urlDecode((String)t[0]);
    }

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "sqlserver") || cfService.existsByLabelStartsWith("sqlserver") || cfService.existsByUriSchemeStartsWith(new String[]{"sqlserver"}) || cfService.existsByCredentialsContainsUriField(new String[]{"sqlserver"});
    }

    @Override
    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }
}

