/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class PostgresqlJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String POSTGRESQL_SCHEME = "postgres";
    public static final String POSTGRES_JDBC_SCHEME = "postgresql";
    public static final String POSTGRESQL_TAG = "postgresql";
    public static final String POSTGRESQL_LABEL = "postgresql";

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, POSTGRESQL_SCHEME, "postgresql") || cfService.existsByTagIgnoreCase(new String[]{"postgresql"}) || cfService.existsByLabelStartsWith("postgresql") || cfService.existsByUriSchemeStartsWith(new String[]{POSTGRESQL_SCHEME}) || cfService.existsByCredentialsContainsUriField(new String[]{POSTGRESQL_SCHEME});
    }

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("postgresql");
        return String.format("%s%s://%s%s/%s%s%s", "jdbc:", "postgresql", uriInfo.getHost(), uriInfo.formatPort(), uriInfo.getPath(), uriInfo.formatUserNameAndPassword(), uriInfo.formatQuery());
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }
}

