/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import io.pivotal.cfenv.spring.boot.ConnectorLibraryDetector;
import java.util.Map;

public class MongoCfEnvProcessor
implements CfEnvProcessor {
    private static String mongoScheme = "mongodb";

    @Override
    public boolean accept(CfService service) {
        boolean serviceIsBound;
        boolean bl = serviceIsBound = service.existsByTagIgnoreCase(new String[]{"mongodb"}) || service.existsByLabelStartsWith("mongolab") || service.existsByUriSchemeStartsWith(new String[]{mongoScheme}) || service.existsByCredentialsContainsUriField(new String[]{mongoScheme});
        if (serviceIsBound) {
            ConnectorLibraryDetector.assertNoConnectorLibrary();
        }
        return serviceIsBound;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        properties.put("spring.data.mongodb.uri", cfCredentials.getUri(new String[]{mongoScheme}));
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.data.mongodb").serviceName("MongoDB").build();
    }
}

