/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvSingleton;
import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class CfSpringCloudConfigClientEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
ApplicationListener<ApplicationEvent> {
    public static final String SPRING_CLOUD_CONFIG_URI = "spring.cloud.config.uri";
    public static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_ID = "spring.cloud.config.client.oauth2.clientId";
    public static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_SECRET = "spring.cloud.config.client.oauth2.clientSecret";
    public static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_ACCESS_TOKEN_URI = "spring.cloud.config.client.oauth2.accessTokenUri";
    private static final String PROPERTY_SOURCE_NAME = "cfSpringCloudConfigClientEnvironmentPostProcessor";
    private static final String CONFIG_SERVER_SERVICE_TAG_NAME = "configuration";
    private static DeferredLog DEFERRED_LOG = new DeferredLog();
    private static int invocationCount;
    private int order = -2147483639;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.increaseInvocationCount();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive((Environment)environment)) {
            CfService cfService;
            CfEnv cfEnv = CfEnvSingleton.getCfEnvInstance();
            try {
                cfService = cfEnv.findServiceByTag(new String[]{CONFIG_SERVER_SERVICE_TAG_NAME});
            }
            catch (Exception e) {
                if (invocationCount == 1) {
                    DEFERRED_LOG.debug((Object)("Skipping execution of CfDataSourceEnvironmentPostProcessor.  " + e.getMessage()));
                }
                return;
            }
            if (cfService != null) {
                CfCredentials cfCredentials = cfService.getCredentials();
                String uri = cfCredentials.getUri(new String[0]);
                String clientId = cfCredentials.getString(new String[]{"client_id"});
                String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
                String accessTokenUri = cfCredentials.getString(new String[]{"access_token_uri"});
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                properties.put(SPRING_CLOUD_CONFIG_URI, uri);
                properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_ID, clientId);
                properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_SECRET, clientSecret);
                properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_ACCESS_TOKEN_URI, accessTokenUri);
                MutablePropertySources propertySources = environment.getPropertySources();
                if (propertySources.contains("commandLineArgs")) {
                    propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, properties));
                } else {
                    propertySources.addFirst((PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, properties));
                }
                if (invocationCount == 1) {
                    DEFERRED_LOG.info((Object)("Setting spring.cloud.config.client properties from bound service [" + cfService.getName() + "]"));
                }
            }
        } else if (invocationCount == 1) {
            DEFERRED_LOG.debug((Object)"Not setting spring.cloud.config.client properties, not in Cloud Foundry Environment");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            DEFERRED_LOG.switchTo(CfSpringCloudConfigClientEnvironmentPostProcessor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseInvocationCount() {
        CfSpringCloudConfigClientEnvironmentPostProcessor cfSpringCloudConfigClientEnvironmentPostProcessor = this;
        synchronized (cfSpringCloudConfigClientEnvironmentPostProcessor) {
            ++invocationCount;
        }
    }
}

